/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.dse.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.stargate.db.BatchType;
import io.stargate.db.PagingPosition;
import io.stargate.db.Parameters;
import io.stargate.db.Result;
import io.stargate.db.datastore.common.util.ColumnUtils;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ImmutableColumn;
import io.stargate.db.schema.ImmutableUserDefinedType;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.PageSize;
import org.apache.cassandra.cql3.QueryHandler;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.statements.BatchStatement;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.LineStringType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.PointType;
import org.apache.cassandra.db.marshal.PolygonType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.rows.ArrayBackedRow;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.exceptions.AlreadyExistsException;
import org.apache.cassandra.exceptions.CassandraException;
import org.apache.cassandra.exceptions.ReadFailureException;
import org.apache.cassandra.exceptions.WriteFailureException;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.stargate.cql3.functions.FunctionName;
import org.apache.cassandra.stargate.db.ConsistencyLevel;
import org.apache.cassandra.stargate.exceptions.AuthenticationException;
import org.apache.cassandra.stargate.exceptions.ConfigurationException;
import org.apache.cassandra.stargate.exceptions.FunctionExecutionException;
import org.apache.cassandra.stargate.exceptions.InvalidRequestException;
import org.apache.cassandra.stargate.exceptions.IsBootstrappingException;
import org.apache.cassandra.stargate.exceptions.OperationExecutionException;
import org.apache.cassandra.stargate.exceptions.OverloadedException;
import org.apache.cassandra.stargate.exceptions.PersistenceException;
import org.apache.cassandra.stargate.exceptions.PreparedQueryNotFoundException;
import org.apache.cassandra.stargate.exceptions.ReadTimeoutException;
import org.apache.cassandra.stargate.exceptions.RequestFailureReason;
import org.apache.cassandra.stargate.exceptions.SyntaxException;
import org.apache.cassandra.stargate.exceptions.TruncateException;
import org.apache.cassandra.stargate.exceptions.UnauthorizedException;
import org.apache.cassandra.stargate.exceptions.UnavailableException;
import org.apache.cassandra.stargate.exceptions.WriteTimeoutException;
import org.apache.cassandra.stargate.locator.InetAddressAndPort;
import org.apache.cassandra.stargate.transport.ProtocolException;
import org.apache.cassandra.stargate.utils.MD5Digest;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.transport.ServerError;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.Flags;
import org.apache.cassandra.utils.NoSpamLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Conversion {
    private static final Logger logger = LoggerFactory.getLogger(Conversion.class);
    private static final NoSpamLogger noSpamLogger = NoSpamLogger.getLogger((Logger)logger, (long)5L, (TimeUnit)TimeUnit.MINUTES);
    private static final LivenessInfo DUMMY_LIVENESS_INFO = LivenessInfo.create((long)0L, (int)0);
    private static final Constructor<?> specificOptionsCtor;
    private static final Constructor<?> defaultOptionsCtor;
    private static final Constructor<?> optionsWithNameCtor;
    private static final Map<Class<? extends AbstractType>, Column.Type> TYPE_MAPPINGS;

    public static ByteBuffer toPagingState(TableMetadata table, PagingPosition pos, Parameters parameters) {
        PagingState.RowMark rowMark;
        Object[] pkValues = table.partitionKeyColumns().stream().map(c -> pos.requiredValue(c.name.toCQLString())).toArray();
        Clustering clustering = table.partitionKeyAsClusteringComparator().make(pkValues);
        ByteBuffer serializedKey = clustering.serializeAsPartitionKey();
        ProtocolVersion protocolVersion = Conversion.toInternal(parameters.protocolVersion());
        switch (pos.resumeFrom()) {
            case NEXT_PARTITION: {
                rowMark = null;
                break;
            }
            case NEXT_ROW: {
                ByteBuffer[] ccValues = (ByteBuffer[])table.clusteringColumns().stream().map(c -> pos.requiredValue(c.name.toCQLString())).toArray(ByteBuffer[]::new);
                Clustering rowClustering = Clustering.make((ByteBuffer[])ccValues);
                ArrayBackedRow row = ArrayBackedRow.noCellLiveRow((Clustering)rowClustering, (LivenessInfo)DUMMY_LIVENESS_INFO);
                rowMark = PagingState.RowMark.create((TableMetadata)table, (Row)row, (ProtocolVersion)protocolVersion);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported paging mode: " + pos.resumeFrom());
            }
        }
        PagingState pagingState = new PagingState(serializedKey, rowMark, pos.remainingRows(), pos.remainingRowsInPartition(), false);
        return pagingState.serialize(protocolVersion);
    }

    public static QueryOptions toInternal(List<ByteBuffer> values, List<String> boundNames, Parameters parameters) {
        ProtocolVersion protocolVersion = Conversion.toInternal(parameters.protocolVersion());
        PagingState pagingState = parameters.pagingState().map(s -> PagingState.deserialize((ByteBuffer)s.duplicate(), (ProtocolVersion)protocolVersion)).orElse(null);
        return Conversion.createOptions(Conversion.toInternal(parameters.consistencyLevel()), values, boundNames, parameters.skipMetadataInResult(), parameters.pageSize().orElse(-1), pagingState, Conversion.toInternal(parameters.serialConsistencyLevel().orElse(ConsistencyLevel.SERIAL)), protocolVersion, parameters.defaultTimestamp().orElse(Long.MIN_VALUE), parameters.defaultKeyspace().orElse(null));
    }

    private static QueryOptions createOptions(org.apache.cassandra.db.ConsistencyLevel consistencyLevel, List<ByteBuffer> values, List<String> boundNames, boolean skipMetadata, int pageSize, PagingState pagingState, org.apache.cassandra.db.ConsistencyLevel serialConsistency, ProtocolVersion protocolVersion, long timestamp, String keyspace) {
        QueryOptions options;
        try {
            QueryOptions.PagingOptions pagingOptions = null;
            if (pageSize > 0) {
                pagingOptions = new QueryOptions.PagingOptions(PageSize.rowsSize((int)pageSize), QueryOptions.PagingOptions.Mechanism.SINGLE, pagingState == null ? null : pagingState.serialize(protocolVersion));
            }
            Object specificOptions = specificOptionsCtor.newInstance(pagingOptions, serialConsistency, timestamp, keyspace);
            Object defaultOptions = defaultOptionsCtor.newInstance(consistencyLevel, values, skipMetadata, specificOptions, protocolVersion);
            options = (QueryOptions)defaultOptions;
            if (boundNames != null) {
                options = (QueryOptions)optionsWithNameCtor.newInstance(defaultOptions, boundNames);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error while trying to bind the query values by name", e);
        }
        return options;
    }

    public static org.apache.cassandra.db.ConsistencyLevel toInternal(ConsistencyLevel cl) {
        return cl == null ? null : org.apache.cassandra.db.ConsistencyLevel.fromCode((int)cl.code);
    }

    public static ConsistencyLevel toExternal(org.apache.cassandra.db.ConsistencyLevel cl) {
        return cl == null ? null : ConsistencyLevel.fromCode((int)cl.code);
    }

    public static ProtocolVersion toInternal(org.apache.cassandra.stargate.transport.ProtocolVersion protocolVersion) {
        return protocolVersion == null ? null : ProtocolVersion.decode((int)protocolVersion.asInt());
    }

    public static org.apache.cassandra.stargate.transport.ProtocolVersion toExternal(ProtocolVersion protocolVersion) {
        return protocolVersion == null ? null : org.apache.cassandra.stargate.transport.ProtocolVersion.decode((int)protocolVersion.asInt(), (boolean)true);
    }

    public static org.apache.cassandra.utils.MD5Digest toInternal(MD5Digest id) {
        return org.apache.cassandra.utils.MD5Digest.wrap((byte[])id.bytes);
    }

    public static MD5Digest toExternal(org.apache.cassandra.utils.MD5Digest id) {
        return MD5Digest.wrap((byte[])id.bytes);
    }

    public static Map<InetAddressAndPort, RequestFailureReason> toExternal(Map<InetAddress, org.apache.cassandra.exceptions.RequestFailureReason> internal) {
        HashMap<InetAddressAndPort, RequestFailureReason> external = new HashMap<InetAddressAndPort, RequestFailureReason>(internal.size());
        for (Map.Entry<InetAddress, org.apache.cassandra.exceptions.RequestFailureReason> entry : internal.entrySet()) {
            external.put(InetAddressAndPort.getByAddress((InetAddress)entry.getKey()), Conversion.toExternal(entry.getValue()));
        }
        return external;
    }

    private static RequestFailureReason toExternal(org.apache.cassandra.exceptions.RequestFailureReason internal) {
        try {
            return RequestFailureReason.valueOf((String)internal.name());
        }
        catch (IllegalArgumentException e) {
            logger.debug("Unknown failure reason: {}", (Object)internal);
            return RequestFailureReason.FROM_THE_FUTURE;
        }
    }

    public static org.apache.cassandra.stargate.db.WriteType toExternal(WriteType internal) {
        return org.apache.cassandra.stargate.db.WriteType.fromOrdinal((int)internal.ordinal());
    }

    public static FunctionName toExternal(org.apache.cassandra.cql3.functions.FunctionName internal) {
        return new FunctionName(internal.keyspace, internal.name);
    }

    public static PersistenceException toExternal(CassandraException e) {
        switch (e.code()) {
            case SERVER_ERROR: {
                return Conversion.addSuppressed((PersistenceException)new org.apache.cassandra.stargate.transport.ServerError(e.getMessage()), (RuntimeException)e);
            }
            case BAD_CREDENTIALS: {
                return Conversion.addSuppressed((PersistenceException)new AuthenticationException(e.getMessage(), e.getCause()), (RuntimeException)e);
            }
            case UNAVAILABLE: {
                org.apache.cassandra.exceptions.UnavailableException ue = (org.apache.cassandra.exceptions.UnavailableException)e;
                return Conversion.addSuppressed((PersistenceException)new UnavailableException(ue.getMessage(), Conversion.toExternal(ue.consistency), ue.required, ue.alive), (RuntimeException)e);
            }
            case OVERLOADED: {
                return Conversion.addSuppressed((PersistenceException)new OverloadedException(e.getMessage()), (RuntimeException)e);
            }
            case IS_BOOTSTRAPPING: {
                return Conversion.addSuppressed((PersistenceException)new IsBootstrappingException(), (RuntimeException)e);
            }
            case TRUNCATE_ERROR: {
                return Conversion.addSuppressed((PersistenceException)(e.getCause() == null ? new TruncateException(e.getMessage()) : new TruncateException(e.getCause())), (RuntimeException)e);
            }
            case WRITE_TIMEOUT: {
                org.apache.cassandra.exceptions.WriteTimeoutException wte = (org.apache.cassandra.exceptions.WriteTimeoutException)e;
                return Conversion.addSuppressed((PersistenceException)new WriteTimeoutException(Conversion.toExternal(wte.writeType), Conversion.toExternal(wte.consistency), wte.received, wte.blockFor, wte.getMessage()), (RuntimeException)e);
            }
            case READ_TIMEOUT: {
                org.apache.cassandra.exceptions.ReadTimeoutException rte = (org.apache.cassandra.exceptions.ReadTimeoutException)e;
                return Conversion.addSuppressed((PersistenceException)new ReadTimeoutException(Conversion.toExternal(rte.consistency), rte.received, rte.blockFor, rte.dataPresent), (RuntimeException)e);
            }
            case READ_FAILURE: {
                ReadFailureException rfe = (ReadFailureException)e;
                return Conversion.addSuppressed((PersistenceException)new org.apache.cassandra.stargate.exceptions.ReadFailureException(Conversion.toExternal(rfe.consistency), rfe.received, rfe.blockFor, rfe.dataPresent, Conversion.toExternal(rfe.failureReasonByEndpoint)), (RuntimeException)e);
            }
            case FUNCTION_FAILURE: {
                if (e instanceof org.apache.cassandra.exceptions.FunctionExecutionException) {
                    org.apache.cassandra.exceptions.FunctionExecutionException fee = (org.apache.cassandra.exceptions.FunctionExecutionException)e;
                    return Conversion.addSuppressed((PersistenceException)new FunctionExecutionException(Conversion.toExternal(fee.functionName), fee.argTypes, fee.detail), (RuntimeException)e);
                }
                if (!(e instanceof org.apache.cassandra.exceptions.OperationExecutionException)) break;
                return Conversion.addSuppressed((PersistenceException)new OperationExecutionException(e.getMessage()), (RuntimeException)e);
            }
            case WRITE_FAILURE: {
                WriteFailureException wfe = (WriteFailureException)e;
                return Conversion.addSuppressed((PersistenceException)new org.apache.cassandra.stargate.exceptions.WriteFailureException(Conversion.toExternal(wfe.consistency), wfe.received, wfe.blockFor, Conversion.toExternal(wfe.writeType), Conversion.toExternal(wfe.failureReasonByEndpoint)), (RuntimeException)e);
            }
            case SYNTAX_ERROR: {
                return Conversion.addSuppressed((PersistenceException)new SyntaxException(e.getMessage()), (RuntimeException)e);
            }
            case UNAUTHORIZED: {
                return new UnauthorizedException(e.getMessage(), e.getCause());
            }
            case INVALID: {
                return Conversion.addSuppressed((PersistenceException)new InvalidRequestException(e.getMessage()), (RuntimeException)e);
            }
            case CONFIG_ERROR: {
                return Conversion.addSuppressed((PersistenceException)new ConfigurationException(e.getMessage(), e.getCause()), (RuntimeException)e);
            }
            case ALREADY_EXISTS: {
                AlreadyExistsException aee = (AlreadyExistsException)e;
                return Conversion.addSuppressed((PersistenceException)(Strings.isNullOrEmpty((String)aee.cfName) ? new org.apache.cassandra.stargate.exceptions.AlreadyExistsException(aee.ksName) : new org.apache.cassandra.stargate.exceptions.AlreadyExistsException(aee.ksName, aee.cfName)), (RuntimeException)e);
            }
            case UNPREPARED: {
                org.apache.cassandra.exceptions.PreparedQueryNotFoundException pnfe = (org.apache.cassandra.exceptions.PreparedQueryNotFoundException)e;
                return Conversion.addSuppressed((PersistenceException)new PreparedQueryNotFoundException(MD5Digest.wrap((byte[])pnfe.id.bytes)), (RuntimeException)e);
            }
        }
        noSpamLogger.error("Unhandled Cassandra exception code {} in the persistence conversion code. This should be fixed (but a ServerError will be use in the meantime)", new Object[0]);
        return new org.apache.cassandra.stargate.transport.ServerError((Throwable)e);
    }

    private static PersistenceException addSuppressed(PersistenceException e, RuntimeException suppressed) {
        e.addSuppressed((Throwable)suppressed);
        return e;
    }

    public static Result.ResultMetadata toResultMetadata(ResultSet.ResultMetadata metadata, ProtocolVersion version) {
        ArrayList columns = new ArrayList();
        if (metadata.names != null) {
            metadata.names.forEach(c -> columns.add(ImmutableColumn.builder().keyspace(c.ksName).table(c.cfName).name(c.name.toString()).type(Conversion.getTypeFromInternal(c.type)).build()));
        }
        EnumSet<Result.Flag> flags = EnumSet.noneOf(Result.Flag.class);
        if (Flags.contains((int)metadata.getFlags(), (int)1)) {
            flags.add(Result.Flag.fromId((int)1));
        }
        if (Flags.contains((int)metadata.getFlags(), (int)2)) {
            flags.add(Result.Flag.fromId((int)2));
        }
        if (Flags.contains((int)metadata.getFlags(), (int)8)) {
            flags.add(Result.Flag.fromId((int)8));
        }
        ByteBuffer pagingState = null;
        if (version != null) {
            pagingState = metadata.getPagingResult() == null || metadata.getPagingResult().state == null ? null : metadata.getPagingResult().state;
        }
        MD5Digest resultMetadataId = metadata.getResultMetadataId() == null ? null : Conversion.toExternal(metadata.getResultMetadataId());
        return new Result.ResultMetadata(flags, columns, resultMetadataId, pagingState);
    }

    public static Result.PreparedMetadata toPreparedMetadata(List<ColumnSpecification> names, short[] indexes) {
        ArrayList columns = new ArrayList();
        names.forEach(c -> columns.add(ImmutableColumn.builder().keyspace(c.ksName).table(c.cfName).name(c.name.toString()).type(Conversion.getTypeFromInternal(c.type)).build()));
        EnumSet<Result.Flag> flags = EnumSet.noneOf(Result.Flag.class);
        if (!names.isEmpty() && ColumnSpecification.allInSameTable(names)) {
            flags.add(Result.Flag.GLOBAL_TABLES_SPEC);
        }
        return new Result.PreparedMetadata(flags, columns, indexes);
    }

    public static Result.SchemaChangeMetadata toSchemaChangeMetadata(ResultMessage resultMessage) {
        ResultMessage.SchemaChange schemaChange = (ResultMessage.SchemaChange)resultMessage;
        Event.SchemaChange change = schemaChange.change;
        return new Result.SchemaChangeMetadata(change.change.toString(), change.target.toString(), change.keyspace, change.name, change.argTypes);
    }

    public static Result toResult(ResultMessage resultMessage, ProtocolVersion version, @Nullable List<String> warnings) {
        return Conversion.toResultInternal(resultMessage, version).setTracingId(resultMessage.getTracingId()).setWarnings(warnings);
    }

    private static Result toResultInternal(ResultMessage resultMessage, ProtocolVersion version) {
        switch (resultMessage.kind) {
            case VOID: {
                return new Result.Void();
            }
            case ROWS: {
                return new Result.Rows(((ResultMessage.Rows)resultMessage).result.rows, Conversion.toResultMetadata(((ResultMessage.Rows)resultMessage).result.metadata, version));
            }
            case SET_KEYSPACE: {
                return new Result.SetKeyspace(((ResultMessage.SetKeyspace)resultMessage).keyspace);
            }
            case SCHEMA_CHANGE: {
                return new Result.SchemaChange(Conversion.toSchemaChangeMetadata(resultMessage));
            }
            case PREPARED: {
                ResultMessage.Prepared prepared = (ResultMessage.Prepared)resultMessage;
                QueryHandler.Prepared preparedStatement = QueryProcessor.instance.getPrepared(prepared.statementId);
                return new Result.Prepared(Conversion.toExternal(prepared.statementId), Conversion.toExternal(prepared.resultMetadataId), Conversion.toResultMetadata(prepared.resultMetadata, null), Conversion.toPreparedMetadata(prepared.metadata.names, preparedStatement.statement.getPartitionKeyBindVariableIndexes()));
            }
        }
        throw new ProtocolException("Unexpected type for RESULT message: " + resultMessage.kind);
    }

    public static PersistenceException convertInternalException(Throwable t) {
        if (t instanceof CassandraException) {
            return Conversion.toExternal((CassandraException)t);
        }
        if (t instanceof org.apache.cassandra.transport.ProtocolException) {
            org.apache.cassandra.transport.ProtocolException ex = (org.apache.cassandra.transport.ProtocolException)t;
            return new ProtocolException(t.getMessage(), Conversion.toExternal(ex.getForcedProtocolVersion()));
        }
        if (t instanceof ServerError) {
            return new org.apache.cassandra.stargate.transport.ServerError(t.getMessage());
        }
        logger.error("Unexpected error thrown by persistence", t);
        return new org.apache.cassandra.stargate.transport.ServerError(t);
    }

    public static List<Object> toInternalQueryOrIds(List<Object> queryOrIds) {
        ArrayList<Object> internal = new ArrayList<Object>(queryOrIds.size());
        for (Object o : queryOrIds) {
            if (o instanceof MD5Digest) {
                internal.add(Conversion.toInternal((MD5Digest)o));
                continue;
            }
            internal.add(o);
        }
        return internal;
    }

    public static BatchStatement.Type toInternal(BatchType external) {
        switch (external) {
            case LOGGED: {
                return BatchStatement.Type.LOGGED;
            }
            case UNLOGGED: {
                return BatchStatement.Type.UNLOGGED;
            }
            case COUNTER: {
                return BatchStatement.Type.COUNTER;
            }
        }
        throw new IllegalArgumentException("Invalid batch type");
    }

    public static Column.ColumnType getTypeFromInternal(AbstractType abstractType) {
        if (abstractType instanceof ReversedType) {
            return Conversion.getTypeFromInternal(((ReversedType)abstractType).baseType);
        }
        if (abstractType instanceof MapType) {
            return Column.Type.Map.of(new Column.ColumnType[]{Conversion.getTypeFromInternal(((MapType)abstractType).getKeysType()), Conversion.getTypeFromInternal(((MapType)abstractType).getValuesType())}).frozen(!abstractType.isMultiCell());
        }
        if (abstractType instanceof SetType) {
            return Column.Type.Set.of(new Column.ColumnType[]{Conversion.getTypeFromInternal(((SetType)abstractType).getElementsType())}).frozen(!abstractType.isMultiCell());
        }
        if (abstractType instanceof ListType) {
            return Column.Type.List.of(new Column.ColumnType[]{Conversion.getTypeFromInternal(((ListType)abstractType).getElementsType())}).frozen(!abstractType.isMultiCell());
        }
        if (abstractType.getClass().equals(TupleType.class)) {
            TupleType tupleType = (TupleType)abstractType;
            return Column.Type.Tuple.of((Column.ColumnType[])((TupleType)abstractType).subTypes().stream().map(t -> Conversion.getTypeFromInternal(t)).toArray(Column.ColumnType[]::new)).frozen(!tupleType.isMultiCell());
        }
        if (abstractType.getClass().equals(UserType.class)) {
            UserType udt = (UserType)abstractType;
            return ImmutableUserDefinedType.builder().keyspace(udt.keyspace).name(udt.getNameAsString()).addAllColumns(Conversion.getUDTColumns(udt)).build().frozen(!udt.isMultiCell());
        }
        Column.Type type = TYPE_MAPPINGS.get(abstractType.getClass());
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Unknown type mapping for %s", (Object[])new Object[]{abstractType.getClass()});
        return type;
    }

    public static List<Column> getUDTColumns(UserType userType) {
        ArrayList<Column> columns = new ArrayList<Column>(userType.fieldTypes().size());
        for (int i = 0; i < userType.fieldTypes().size(); ++i) {
            columns.add((Column)ImmutableColumn.builder().name(userType.fieldName(i).toString()).type(Conversion.getTypeFromInternal(userType.fieldType(i))).kind(Column.Kind.Regular).build());
        }
        return columns;
    }

    static {
        try {
            Class<?> defaultOptionsClass = Class.forName("org.apache.cassandra.cql3.QueryOptions$DefaultQueryOptions");
            Class<?> specificOptionsClass = Class.forName("org.apache.cassandra.cql3.QueryOptions$SpecificOptions");
            Class<?> withNamesClass = Class.forName("org.apache.cassandra.cql3.QueryOptions$OptionsWithNames");
            specificOptionsCtor = specificOptionsClass.getDeclaredConstructor(QueryOptions.PagingOptions.class, org.apache.cassandra.db.ConsistencyLevel.class, Long.TYPE, String.class);
            specificOptionsCtor.setAccessible(true);
            defaultOptionsCtor = defaultOptionsClass.getDeclaredConstructor(org.apache.cassandra.db.ConsistencyLevel.class, List.class, Boolean.TYPE, specificOptionsClass, ProtocolVersion.class);
            defaultOptionsCtor.setAccessible(true);
            optionsWithNameCtor = withNamesClass.getDeclaredConstructor(defaultOptionsClass, List.class);
            optionsWithNameCtor.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Error during initialization of the persistence layer: some reflection-based accesses cannot be setup.", e);
        }
        HashMap<Class<LineStringType>, Column.Type> types = new HashMap<Class<LineStringType>, Column.Type>();
        Arrays.asList(Column.Type.values()).forEach(ct -> {
            if (ct != Column.Type.Tuple && ct != Column.Type.List && ct != Column.Type.Map && ct != Column.Type.Set && ct != Column.Type.Point && ct != Column.Type.Polygon && ct != Column.Type.LineString && ct != Column.Type.UDT) {
                types.put((Class<LineStringType>)ColumnUtils.toInternalType((Column.ColumnType)ct).getClass(), (Column.Type)ct);
            }
        });
        types.put(PointType.class, Column.Type.Point);
        types.put(PolygonType.class, Column.Type.Polygon);
        types.put(LineStringType.class, Column.Type.LineString);
        TYPE_MAPPINGS = ImmutableMap.copyOf(types);
    }
}

