/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.dse.impl;

import com.datastax.bdp.cassandra.auth.AuthRequestExecutionException;
import io.stargate.auth.AuthorizationOutcome;
import io.stargate.auth.AuthorizationProcessor;
import io.stargate.auth.PermissionKind;
import io.stargate.auth.entity.AccessPermission;
import io.stargate.auth.entity.Actor;
import io.stargate.auth.entity.AuthorizedResource;
import io.stargate.auth.entity.EntitySelector;
import io.stargate.auth.entity.ImmutableAccessPermission;
import io.stargate.auth.entity.ImmutableActor;
import io.stargate.auth.entity.ImmutableAuthorizedResource;
import io.stargate.auth.entity.ResourceKind;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.CassandraAuthorizer;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.FunctionResource;
import org.apache.cassandra.auth.GrantMode;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.auth.permission.CorePermission;
import org.apache.cassandra.exceptions.ExceptionCode;
import org.apache.cassandra.stargate.exceptions.RequestValidationException;
import org.javatuples.Pair;

public class DelegatingAuthorizer
extends CassandraAuthorizer {
    private static final Duration PROCESSING_TIMEOUT = Duration.parse(System.getProperty("stargate.authorization.processing.timeout", "PT5M"));
    private AuthorizationProcessor authProcessor;

    public void setProcessor(AuthorizationProcessor processor) {
        this.authProcessor = processor;
    }

    public Set<Permission> grant(AuthenticatedUser performer, Set<Permission> permissions, IResource resource, RoleResource grantee, GrantMode ... grantModes) {
        if (this.authProcessor == null) {
            return super.grant(performer, permissions, resource, grantee, grantModes);
        }
        ArrayList stages = new ArrayList(grantModes.length);
        permissions = this.filterSupported(permissions);
        for (GrantMode grantMode : grantModes) {
            Pair<PermissionKind, AuthorizationOutcome> mode = DelegatingAuthorizer.grantMode(grantMode);
            CompletionStage stage = this.authProcessor.addPermissions((Actor)ImmutableActor.of((String)performer.getName()), (AuthorizationOutcome)mode.getValue1(), (PermissionKind)mode.getValue0(), DelegatingAuthorizer.permissions(permissions), DelegatingAuthorizer.resource(resource), DelegatingAuthorizer.role(grantee));
            stages.add(stage.toCompletableFuture());
        }
        DelegatingAuthorizer.get(CompletableFuture.allOf(stages.toArray(new CompletableFuture[0])));
        return permissions;
    }

    public Set<Permission> revoke(AuthenticatedUser performer, Set<Permission> permissions, IResource resource, RoleResource revokee, GrantMode ... grantModes) {
        if (this.authProcessor == null) {
            return super.revoke(performer, permissions, resource, revokee, grantModes);
        }
        ArrayList stages = new ArrayList(grantModes.length);
        permissions = this.filterSupported(permissions);
        for (GrantMode grantMode : grantModes) {
            Pair<PermissionKind, AuthorizationOutcome> mode = DelegatingAuthorizer.grantMode(grantMode);
            CompletionStage stage = this.authProcessor.removePermissions((Actor)ImmutableActor.of((String)performer.getName()), (AuthorizationOutcome)mode.getValue1(), (PermissionKind)mode.getValue0(), DelegatingAuthorizer.permissions(permissions), DelegatingAuthorizer.resource(resource), DelegatingAuthorizer.role(revokee));
            stages.add(stage.toCompletableFuture());
        }
        DelegatingAuthorizer.get(CompletableFuture.allOf(stages.toArray(new CompletableFuture[0])));
        return permissions;
    }

    private static void get(CompletionStage<Void> stage) {
        try {
            stage.toCompletableFuture().get(PROCESSING_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RequestValidationException) {
                throw (RequestValidationException)cause;
            }
            throw new AuthRequestExecutionException(ExceptionCode.SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new AuthRequestExecutionException(ExceptionCode.SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    private static Pair<PermissionKind, AuthorizationOutcome> grantMode(GrantMode grantMode) {
        switch (grantMode) {
            case GRANTABLE: {
                return Pair.with((Object)PermissionKind.AUTHORITY, (Object)AuthorizationOutcome.ALLOW);
            }
            case GRANT: {
                return Pair.with((Object)PermissionKind.ACCESS, (Object)AuthorizationOutcome.ALLOW);
            }
            case RESTRICT: {
                return Pair.with((Object)PermissionKind.ACCESS, (Object)AuthorizationOutcome.DENY);
            }
        }
        throw new UnsupportedOperationException("Unsupported grant mode: " + grantMode);
    }

    private static EntitySelector role(RoleResource roleResource) {
        if (!roleResource.hasParent()) {
            return EntitySelector.wildcard();
        }
        return EntitySelector.byName((String)roleResource.getRoleName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AuthorizedResource resource(IResource resource) {
        String resourcePath = resource.getName();
        if (resource instanceof FunctionResource) {
            ImmutableAuthorizedResource authResource = ImmutableAuthorizedResource.of((ResourceKind)ResourceKind.FUNCTION);
            FunctionResource fr = (FunctionResource)resource;
            boolean hasKeyspace = resourcePath.indexOf("/") > 0;
            if (!hasKeyspace) return authResource;
            EntitySelector keyspace = EntitySelector.byName((String)fr.getKeyspace());
            authResource = authResource.withKeyspace(keyspace);
            String subPath = resourcePath.substring(resourcePath.indexOf(47));
            int idx = subPath.indexOf(47);
            if (idx <= 0) return authResource;
            EntitySelector element = EntitySelector.byName((String)subPath.substring(idx));
            return authResource.withElement(element);
        }
        if (!(resource instanceof DataResource)) throw new UnsupportedOperationException("Unsupported resource type: " + resource.getClass());
        DataResource dr = (DataResource)resource;
        if (dr.isRootLevel()) {
            return ImmutableAuthorizedResource.of((ResourceKind)ResourceKind.KEYSPACE);
        }
        if (dr.isKeyspaceLevel()) {
            EntitySelector keyspace = EntitySelector.byName((String)dr.getKeyspace());
            return ImmutableAuthorizedResource.of((ResourceKind)ResourceKind.KEYSPACE).withKeyspace(keyspace);
        }
        if (dr.isAllTablesLevel()) {
            EntitySelector keyspace = EntitySelector.byName((String)dr.getKeyspace());
            return ImmutableAuthorizedResource.of((ResourceKind)ResourceKind.TABLE).withKeyspace(keyspace);
        }
        if (!dr.isTableLevel()) throw new IllegalArgumentException("Unsupported data resource: " + dr);
        EntitySelector keyspace = EntitySelector.byName((String)dr.getKeyspace());
        EntitySelector element = EntitySelector.byName((String)dr.getTable());
        return ImmutableAuthorizedResource.of((ResourceKind)ResourceKind.TABLE).withKeyspace(keyspace).withElement(element);
    }

    private Set<Permission> filterSupported(Set<Permission> permissions) {
        return permissions.stream().filter(DelegatingAuthorizer::supported).collect(Collectors.toSet());
    }

    private static boolean supported(Permission permission) {
        return CorePermission.getDomain().equals(permission.domain());
    }

    private static Collection<AccessPermission> permissions(Set<Permission> permissions) {
        ArrayList<AccessPermission> accessPermissions = new ArrayList<AccessPermission>(permissions.size());
        for (Permission permission : permissions) {
            if (!DelegatingAuthorizer.supported(permission)) {
                throw new IllegalArgumentException("Unsupported permission: " + permission);
            }
            accessPermissions.add((AccessPermission)ImmutableAccessPermission.of((String)permission.name()));
        }
        return accessPermissions;
    }
}

