/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.dse.impl;

import com.datastax.bdp.db.schema.parameters.Definition;
import com.google.common.collect.Iterables;
import io.stargate.db.datastore.common.AbstractCassandraSchemaConverter;
import io.stargate.db.dse.impl.Conversion;
import io.stargate.db.schema.Column;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.ReplicationParams;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.ViewTableMetadata;

public class SchemaConverter
extends AbstractCassandraSchemaConverter<KeyspaceMetadata, TableMetadata, ColumnMetadata, UserType, IndexMetadata, ViewTableMetadata> {
    protected String keyspaceName(KeyspaceMetadata keyspace) {
        return keyspace.name;
    }

    protected Map<String, String> replicationOptions(KeyspaceMetadata keyspace) {
        return ((ReplicationParams)keyspace.params.get((Definition)KeyspaceParams.REPLICATION)).asMap();
    }

    protected boolean usesDurableWrites(KeyspaceMetadata keyspace) {
        return keyspace.params.getBoolean((Definition)KeyspaceParams.DURABLE_WRITES);
    }

    protected Iterable<TableMetadata> tables(KeyspaceMetadata keyspace) {
        return keyspace.tables;
    }

    protected Iterable<UserType> userTypes(KeyspaceMetadata keyspace) {
        return keyspace.types;
    }

    protected Iterable<ViewTableMetadata> views(KeyspaceMetadata keyspace) {
        return keyspace.views;
    }

    protected String tableName(TableMetadata table) {
        return table.name;
    }

    protected Iterable<ColumnMetadata> columns(TableMetadata table) {
        return () -> ((TableMetadata)table).allColumnsInSelectOrder();
    }

    protected String columnName(ColumnMetadata column) {
        return column.name.toString();
    }

    protected Column.ColumnType columnType(ColumnMetadata column) {
        return Conversion.getTypeFromInternal(column.type);
    }

    protected Column.Order columnClusteringOrder(ColumnMetadata column) {
        switch (column.clusteringOrder()) {
            case ASC: {
                return Column.Order.ASC;
            }
            case DESC: {
                return Column.Order.DESC;
            }
            case NONE: {
                return null;
            }
        }
        throw new IllegalStateException("Clustering columns should always have an order");
    }

    protected Column.Kind columnKind(ColumnMetadata column) {
        switch (column.kind) {
            case REGULAR: {
                return Column.Kind.Regular;
            }
            case STATIC: {
                return Column.Kind.Static;
            }
            case PARTITION_KEY: {
                return Column.Kind.PartitionKey;
            }
            case CLUSTERING: {
                return Column.Kind.Clustering;
            }
        }
        throw new IllegalStateException("Unknown column kind");
    }

    protected Iterable<IndexMetadata> secondaryIndexes(TableMetadata table) {
        return Iterables.transform((Iterable)Keyspace.openAndGetStore((TableMetadata)table).indexManager.listIndexes(), Index::getIndexMetadata);
    }

    protected String indexName(IndexMetadata index) {
        return index.name;
    }

    protected String indexTarget(IndexMetadata index) {
        return (String)index.options.get("target");
    }

    protected boolean isCustom(IndexMetadata index) {
        return index.kind == IndexMetadata.Kind.CUSTOM;
    }

    protected String indexClass(IndexMetadata index) {
        return (String)index.options.get("class_name");
    }

    protected Map<String, String> indexOptions(IndexMetadata index) {
        return index.options.entrySet().stream().filter(x -> !EXCLUDED_INDEX_OPTIONS.contains(x.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    protected List<Column> userTypeFields(UserType userType) {
        return Conversion.getUDTColumns(userType);
    }

    protected String userTypeName(UserType userType) {
        return userType.getNameAsString();
    }

    protected TableMetadata asTable(ViewTableMetadata view) {
        return view;
    }

    protected boolean isBaseTableOf(TableMetadata table, ViewTableMetadata view) {
        return view.baseTable().id.equals((Object)table.id);
    }
}

