/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.dse.impl;

import com.datastax.bdp.db.nodes.BootstrapState;
import com.datastax.bdp.db.nodes.virtual.LocalNodeSystemView;
import com.datastax.bdp.db.nodes.virtual.NodesSystemViews;
import io.stargate.db.dse.impl.StargateLocalInfo;
import io.stargate.db.dse.impl.StargateNodeView;
import io.stargate.db.dse.impl.StargateSystemKeyspace;
import org.apache.cassandra.db.virtual.DataSet;

public class StargateLocalView
extends StargateNodeView {
    StargateLocalView() {
        super(StargateSystemKeyspace.virtualFromLegacy(NodesSystemViews.Local, "local"));
    }

    public DataSet data() {
        DataSet result = this.newDataSet();
        StargateLocalInfo info = StargateSystemKeyspace.instance.getLocal().copy();
        DataSet.RowBuilder rowBuilder = result.newRowBuilder(new Object[0]).addColumn("bootstrapped", () -> StargateLocalView.safeToString(BootstrapState.COMPLETED)).addColumn("broadcast_address", info::getBroadcastAddress).addColumn("cluster_name", info::getClusterName).addColumn("cql_version", () -> StargateLocalView.safeToString(info.getCqlVersion())).addColumn("gossip_generation", () -> null).addColumn("listen_address", info::getListenAddress).addColumn("native_protocol_version", info::getNativeProtocolVersion).addColumn("partitioner", info::getPartitioner).addColumn("truncated_at", () -> null).addColumn("last_nodesync_checkpoint_time", () -> null);
        result.addRow((Object)LocalNodeSystemView.KEY, this.completeRow(rowBuilder, info));
        return result;
    }
}

