/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.dse.impl;

import io.stargate.db.dse.impl.StargateNodeInfo;
import io.stargate.db.dse.impl.StargateSystemKeyspace;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.db.virtual.DataSet;
import org.apache.cassandra.schema.TableMetadata;

public abstract class StargateNodeView
extends AbstractVirtualTable {
    StargateNodeView(TableMetadata metadata) {
        super(metadata);
    }

    DataSet.RowBuilder completeRow(DataSet.RowBuilder rowBuilder, StargateNodeInfo info) {
        return rowBuilder.addColumn("rpc_address", info::getRpcAddress).addColumn("native_transport_address", info::getNativeAddress).addColumn("data_center", info::getDataCenter).addColumn("host_id", info::getHostId).addColumn("rack", info::getRack).addColumn("release_version", () -> StargateNodeView.safeToString(info.getReleaseVersion())).addColumn("schema_version", () -> StargateSystemKeyspace.SCHEMA_VERSION).addColumn("tokens", info::getTokens).addColumn("native_transport_port", info::getNativePort).addColumn("native_transport_port_ssl", info::getNativePortSsl).addColumn("storage_port", info::getStoragePort).addColumn("storage_port_ssl", info::getStoragePortSsl).addColumn("jmx_port", info::getJmxPort).addColumn("dse_version", () -> null).addColumn("graph", () -> false).addColumn("server_id", null).addColumn("workload", () -> null).addColumn("workloads", () -> null);
    }

    static String safeToString(Object o) {
        return o != null ? o.toString() : null;
    }
}

