/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.dse.impl;

import com.datastax.bdp.db.nodes.Nodes;
import com.datastax.bdp.db.util.ProductVersion;
import io.stargate.db.dse.impl.StargateLocalInfo;
import io.stargate.db.dse.impl.StargateLocalView;
import io.stargate.db.dse.impl.StargatePeerInfo;
import io.stargate.db.dse.impl.StargatePeersView;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.virtual.VirtualKeyspace;
import org.apache.cassandra.db.virtual.VirtualTable;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.schema.SchemaManager;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MurmurHash;

public class StargateSystemKeyspace {
    public static final String SYSTEM_KEYSPACE_NAME = "stargate_system";
    public static final String LOCAL_TABLE_NAME = "local";
    public static final String PEERS_TABLE_NAME = "peers";
    public static final UUID SCHEMA_VERSION = UUID.fromString("17846767-28a1-4acd-a967-f609ff1375f1");
    public static final StargateSystemKeyspace instance = new StargateSystemKeyspace();
    private final ConcurrentMap<InetAddress, StargatePeerInfo> peers = new ConcurrentHashMap<InetAddress, StargatePeerInfo>();
    private final StargateLocalInfo local = new StargateLocalInfo();

    public ConcurrentMap<InetAddress, StargatePeerInfo> getPeers() {
        return this.peers;
    }

    public StargateLocalInfo getLocal() {
        return this.local;
    }

    public void persistLocalMetadata() {
        this.local.setClusterName(DatabaseDescriptor.getClusterName());
        this.local.setReleaseVersion(ProductVersion.getReleaseVersion().toString());
        this.local.setCqlVersion(QueryProcessor.CQL_VERSION);
        this.local.setNativeProtocolVersion(String.valueOf(ProtocolVersion.CURRENT.asInt()));
        this.local.setDataCenter(DatabaseDescriptor.getLocalDataCenter());
        this.local.setRack(DatabaseDescriptor.getLocalRack());
        this.local.setPartitioner(DatabaseDescriptor.getPartitioner().getClass().getName());
        this.local.setBroadcastAddress(FBUtilities.getBroadcastAddress());
        this.local.setListenAddress(FBUtilities.getLocalAddress());
        this.local.setNativeAddress(DatabaseDescriptor.getNativeTransportAddress());
        this.local.setNativePort(DatabaseDescriptor.getNativeTransportPort());
        this.local.setNativePortSsl(DatabaseDescriptor.getNativeTransportPortSSL());
        this.local.setStoragePort(DatabaseDescriptor.getStoragePort());
        this.local.setStoragePortSsl(DatabaseDescriptor.getSSLStoragePort());
        this.local.setJmxPort(DatabaseDescriptor.getJMXPort().orElse(null));
        this.local.setHostId(Nodes.local().get().getHostId());
        this.local.setTokens(StargateSystemKeyspace.generateRandomTokens(FBUtilities.getNativeTransportBroadcastAddress(), DatabaseDescriptor.getNumTokens()));
    }

    public static boolean isSystemLocal(SelectStatement statement) {
        return statement.table().equals("local_node");
    }

    public static boolean isSystemLocalOrPeers(CQLStatement statement) {
        if (statement instanceof SelectStatement) {
            SelectStatement selectStatement = (SelectStatement)statement;
            return selectStatement.keyspace().equals("system_views") && (StargateSystemKeyspace.isSystemLocal(selectStatement) || selectStatement.table().equals("peer_nodes"));
        }
        return false;
    }

    public static void initialize() {
        VirtualKeyspace.Builder builder = VirtualKeyspace.newBuilder((String)SYSTEM_KEYSPACE_NAME).addView((VirtualTable)new StargatePeersView()).addView((VirtualTable)new StargateLocalView());
        SchemaManager.instance.load(builder.build());
    }

    public static TableMetadata virtualFromLegacy(TableMetadata legacy, String table) {
        TableMetadata.Builder builder = (TableMetadata.Builder)TableMetadata.builder((String)SYSTEM_KEYSPACE_NAME, (String)table).kind(TableMetadata.Kind.VIRTUAL);
        legacy.partitionKeyColumns().forEach(cm -> {
            TableMetadata.Builder cfr_ignored_0 = (TableMetadata.Builder)builder.addPartitionKeyColumn(cm.name, cm.type);
        });
        legacy.staticColumns().forEach(cm -> {
            TableMetadata.Builder cfr_ignored_0 = (TableMetadata.Builder)builder.addStaticColumn(cm.name, cm.type.freeze());
        });
        legacy.clusteringColumns().forEach(cm -> {
            TableMetadata.Builder cfr_ignored_0 = (TableMetadata.Builder)builder.addClusteringColumn(cm.name, cm.type);
        });
        legacy.regularColumns().forEach(cm -> {
            TableMetadata.Builder cfr_ignored_0 = (TableMetadata.Builder)builder.addRegularColumn(cm.name, cm.type.freeze());
        });
        return builder.build();
    }

    public static Set<String> generateRandomTokens(InetAddress inetAddress, int numTokens) {
        Random random = new Random(StargateSystemKeyspace.getSeed(inetAddress));
        IPartitioner partitioner = DatabaseDescriptor.getPartitioner();
        Token.TokenFactory tokenFactory = partitioner.getTokenFactory();
        HashSet<String> tokens = new HashSet<String>(numTokens);
        while (tokens.size() < numTokens) {
            tokens.add(tokenFactory.toString(partitioner.getRandomToken(random)));
        }
        return tokens;
    }

    private static long getSeed(InetAddress inetAddress) {
        ByteBuffer bytes = ByteBuffer.wrap(inetAddress.getAddress());
        return MurmurHash.hash2_64((ByteBuffer)bytes, (int)bytes.position(), (int)bytes.remaining(), (long)0L);
    }
}

