/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.dse.impl.interceptors;

import com.google.common.collect.Sets;
import io.reactivex.Single;
import io.stargate.db.EventListener;
import io.stargate.db.dse.impl.StargateNodeInfo;
import io.stargate.db.dse.impl.StargatePeerInfo;
import io.stargate.db.dse.impl.StargateSystemKeyspace;
import io.stargate.db.dse.impl.interceptors.QueryInterceptor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultQueryInterceptor
implements QueryInterceptor,
IEndpointStateChangeSubscriber {
    private static final Logger logger = LoggerFactory.getLogger(DefaultQueryInterceptor.class);
    private final List<EventListener> listeners = new CopyOnWriteArrayList<EventListener>();
    private final Set<InetAddress> liveStargateNodes = Sets.newConcurrentHashSet();
    private final Set<InetAddress> endpointsPendingJoinedNotification = ConcurrentHashMap.newKeySet();

    @Override
    public void initialize() {
        StargateSystemKeyspace.initialize();
        Gossiper.instance.register((IEndpointStateChangeSubscriber)this);
        StargateSystemKeyspace.instance.persistLocalMetadata();
    }

    @Override
    public Single<ResultMessage> interceptQuery(CQLStatement statement, QueryState state, QueryOptions options, Map<String, ByteBuffer> customPayload, long queryStartNanoTime) {
        if (!StargateSystemKeyspace.isSystemLocalOrPeers(statement)) {
            return null;
        }
        return DefaultQueryInterceptor.interceptSystemLocalOrPeers(statement, state, options, queryStartNanoTime);
    }

    @Override
    public void register(EventListener listener) {
        this.listeners.add(listener);
    }

    private static Single<ResultMessage> interceptSystemLocalOrPeers(CQLStatement statement, QueryState state, QueryOptions options, long queryStartNanoTime) {
        SelectStatement selectStatement = (SelectStatement)statement;
        SelectStatement.Raw rawStatement = (SelectStatement.Raw)QueryProcessor.parseStatement((String)selectStatement.queryString);
        rawStatement.setKeyspace("stargate_system");
        SelectStatement interceptStatement = rawStatement.prepare(state.getClientState());
        Single rows = interceptStatement.execute(state, options, queryStartNanoTime);
        return rows.map(r -> new ResultMessage.Rows(new ResultSet(selectStatement.getResultMetadata(), r.result.rows)));
    }

    public void onJoin(InetAddress endpoint, EndpointState state) {
        if (!DefaultQueryInterceptor.isStargateNode(state)) {
            return;
        }
        this.joinCluster(endpoint, state);
    }

    public void beforeChange(InetAddress endpoint, EndpointState currentState, ApplicationState newStateKey, VersionedValue newValue) {
    }

    public void onChange(InetAddress endpoint, ApplicationState state, VersionedValue value) {
        if (state == ApplicationState.STATUS) {
            return;
        }
        EndpointState epState = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (epState == null || Gossiper.instance.isDeadState(epState)) {
            return;
        }
        if (!DefaultQueryInterceptor.isStargateNode(epState)) {
            return;
        }
        if (!this.joinCluster(endpoint, epState)) {
            this.applyState(endpoint, state, value, epState);
        }
    }

    public void onAlive(InetAddress endpoint, EndpointState state) {
        if (!DefaultQueryInterceptor.isStargateNode(state)) {
            return;
        }
        this.notifyUp(endpoint);
    }

    public void onDead(InetAddress endpoint, EndpointState state) {
        if (!DefaultQueryInterceptor.isStargateNode(state)) {
            return;
        }
        this.notifyDown(endpoint);
    }

    public void onRemove(InetAddress endpoint) {
        this.leaveCluster(endpoint);
    }

    public void onRestart(InetAddress endpoint, EndpointState state) {
    }

    private boolean joinCluster(InetAddress endpoint, EndpointState state) {
        if (!this.liveStargateNodes.add(endpoint)) {
            return false;
        }
        for (Map.Entry entry : state.states()) {
            this.applyState(endpoint, (ApplicationState)entry.getKey(), (VersionedValue)entry.getValue(), state);
        }
        if (StorageService.instance.isRpcReady(endpoint)) {
            this.notifyJoinCluster(endpoint);
        } else {
            this.endpointsPendingJoinedNotification.add(endpoint);
        }
        return true;
    }

    private void leaveCluster(InetAddress endpoint) {
        if (!this.liveStargateNodes.remove(endpoint)) {
            return;
        }
        StargateSystemKeyspace.instance.getPeers().remove(endpoint);
        InetAddress nativeAddress = this.getNativeAddress(endpoint);
        for (EventListener listener : this.listeners) {
            listener.onLeaveCluster(nativeAddress, -1);
        }
    }

    private void notifyJoinCluster(InetAddress endpoint) {
        InetAddress nativeAddress = this.getNativeAddress(endpoint);
        for (EventListener listener : this.listeners) {
            listener.onJoinCluster(nativeAddress, -1);
        }
    }

    private void notifyRpcChange(InetAddress endpoint, boolean isReady) {
        if (isReady) {
            this.notifyUp(endpoint);
        } else {
            this.notifyDown(endpoint);
        }
    }

    private void notifyUp(InetAddress endpoint) {
        if (!StorageService.instance.isRpcReady(endpoint) || !Gossiper.instance.isAlive(endpoint)) {
            return;
        }
        if (this.endpointsPendingJoinedNotification.remove(endpoint)) {
            this.notifyJoinCluster(endpoint);
        }
        InetAddress nativeAddress = this.getNativeAddress(endpoint);
        for (EventListener listener : this.listeners) {
            listener.onUp(nativeAddress, -1);
        }
    }

    private void applyState(InetAddress endpoint, ApplicationState state, VersionedValue value, EndpointState epState) {
        switch (state) {
            case RELEASE_VERSION: {
                this.updatePeer(endpoint, value.value, StargateNodeInfo::setReleaseVersion);
                break;
            }
            case DC: {
                this.updatePeer(endpoint, value.value, StargateNodeInfo::setDataCenter);
                break;
            }
            case RACK: {
                this.updatePeer(endpoint, value.value, StargateNodeInfo::setRack);
                break;
            }
            case NATIVE_TRANSPORT_ADDRESS: {
                try {
                    this.updatePeer(endpoint, InetAddress.getByName(value.value), StargateNodeInfo::setNativeAddress);
                    break;
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException(e);
                }
            }
            case NATIVE_TRANSPORT_PORT: {
                this.updatePeer(endpoint, Integer.parseInt(value.value), StargateNodeInfo::setNativePort);
                break;
            }
            case NATIVE_TRANSPORT_PORT_SSL: {
                this.updatePeer(endpoint, Integer.parseInt(value.value), StargateNodeInfo::setNativePortSsl);
                break;
            }
            case STORAGE_PORT: {
                this.updatePeer(endpoint, Integer.parseInt(value.value), StargateNodeInfo::setStoragePort);
                break;
            }
            case STORAGE_PORT_SSL: {
                this.updatePeer(endpoint, Integer.parseInt(value.value), StargateNodeInfo::setStoragePortSsl);
                break;
            }
            case JMX_PORT: {
                this.updatePeer(endpoint, Integer.parseInt(value.value), StargateNodeInfo::setJmxPort);
                break;
            }
            case HOST_ID: {
                this.updatePeer(endpoint, UUID.fromString(value.value), StargateNodeInfo::setHostId);
                break;
            }
            case NATIVE_TRANSPORT_READY: {
                this.notifyRpcChange(endpoint, epState.isRpcReady());
                break;
            }
        }
    }

    private <V> void updatePeer(InetAddress endpoint, V value, BiConsumer<StargatePeerInfo, V> updater) {
        if (!FBUtilities.getBroadcastAddress().equals(endpoint)) {
            StargatePeerInfo peer = StargateSystemKeyspace.instance.getPeers().computeIfAbsent(endpoint, StargatePeerInfo::new);
            updater.accept(peer, value);
        }
    }

    private void notifyDown(InetAddress endpoint) {
        InetAddress nativeAddress = this.getNativeAddress(endpoint);
        for (EventListener listener : this.listeners) {
            listener.onDown(nativeAddress, -1);
        }
    }

    private InetAddress getNativeAddress(InetAddress endpoint) {
        try {
            return InetAddress.getByName(StorageService.instance.getRpcaddress(endpoint));
        }
        catch (UnknownHostException e) {
            logger.error("Problem retrieving RPC address for {}", (Object)endpoint, (Object)e);
            return endpoint;
        }
    }

    private static boolean isStargateNode(EndpointState epState) {
        VersionedValue value = epState.getApplicationState(ApplicationState.X10);
        return value != null && value.value.equals("stargate");
    }
}

