/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Metric;
import com.google.common.annotations.VisibleForTesting;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.Counter;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.Histogram;

public abstract class AIOMetrics {
    @VisibleForTesting
    public final Histogram aioLatency;
    @VisibleForTesting
    public final Counter retries;
    @VisibleForTesting
    public final Counter failures;

    private AIOMetrics(Histogram aioLatency, Counter retries, Counter failures) {
        this.aioLatency = aioLatency;
        this.retries = retries;
        this.failures = failures;
    }

    public static PerCore createForCore(int coreId) {
        return new PerCore(coreId);
    }

    public static Aggregated createAggregate(Iterable<PerCore> aioCores) {
        return new Aggregated(aioCores);
    }

    public static class Aggregated
    extends AIOMetrics {
        public Aggregated(Iterable<PerCore> perCoreMetrics) {
            super(CassandraMetricsRegistry.Metrics.histogram(DefaultNameFactory.createMetricName("AIO", "CompletionLatency", "AIO/all"), true, true), CassandraMetricsRegistry.Metrics.counter(DefaultNameFactory.createMetricName("AIO", "Retries", "AIO/all"), true), CassandraMetricsRegistry.Metrics.counter(DefaultNameFactory.createMetricName("AIO", "Failures", "AIO/all"), true));
            for (AIOMetrics aIOMetrics : perCoreMetrics) {
                this.aioLatency.compose((Metric)aIOMetrics.aioLatency);
                this.retries.compose(aIOMetrics.retries);
                this.failures.compose(aIOMetrics.failures);
            }
        }
    }

    public static class PerCore
    extends AIOMetrics {
        private PerCore(int coreId) {
            super(CassandraMetricsRegistry.Metrics.histogram(DefaultNameFactory.createMetricName("AIO", "CompletionLatency", "AIO/" + coreId), true), CassandraMetricsRegistry.Metrics.counter(DefaultNameFactory.createMetricName("AIO", "Retries", "AIO/" + coreId)), CassandraMetricsRegistry.Metrics.counter(DefaultNameFactory.createMetricName("AIO", "Failures", "AIO/" + coreId)));
        }

        public void increaseRetryCounter() {
            this.retries.inc();
        }

        public void increaseFailureCounter() {
            this.failures.inc();
        }

        public void updateLatencyHistogram(long value) {
            this.aioLatency.update(value);
        }
    }
}

