/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Gauge;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.Counter;
import org.apache.cassandra.metrics.Meter;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.metrics.ThreadPoolMetricNameFactory;

public abstract class AbstractThreadPoolMetrics {
    private final List<CassandraMetricsRegistry.MetricName> tracked = new ArrayList<CassandraMetricsRegistry.MetricName>();
    final MetricNameFactory factory;

    AbstractThreadPoolMetrics(String path, String poolName) {
        this.factory = new ThreadPoolMetricNameFactory("ThreadPools", path, poolName);
    }

    public synchronized void release() {
        for (CassandraMetricsRegistry.MetricName name : this.tracked) {
            CassandraMetricsRegistry.Metrics.remove(name);
        }
        this.tracked.clear();
    }

    Gauge<Integer> registerIntMetric(String name, Gauge<Integer> gauge) {
        return CassandraMetricsRegistry.Metrics.register(this.trackedMetric(name), gauge);
    }

    Gauge<Long> registerLongMetric(String name, Gauge<Long> gauge) {
        return CassandraMetricsRegistry.Metrics.register(this.trackedMetric(name), gauge);
    }

    Meter registerMeterMetric(String name, Meter meter) {
        return CassandraMetricsRegistry.Metrics.register(this.trackedMetric(name), meter);
    }

    Counter registeredCounter(String name) {
        return CassandraMetricsRegistry.Metrics.counter(this.trackedMetric(name));
    }

    private synchronized CassandraMetricsRegistry.MetricName trackedMetric(String name) {
        CassandraMetricsRegistry.MetricName metricName = this.factory.createMetricName(name);
        this.tracked.add(metricName);
        return metricName;
    }
}

