/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Gauge;
import com.datastax.bdp.db.backups.BackupConfiguration;
import com.datastax.bdp.db.backups.BackupTaskMetrics;
import com.datastax.bdp.db.backups.executor.Operation;
import com.datastax.bdp.db.backups.executor.OperationExecutor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.Counter;
import org.apache.cassandra.metrics.DbMetrics;
import org.apache.cassandra.metrics.Histogram;
import org.apache.cassandra.metrics.Meter;
import org.apache.cassandra.metrics.MetricNameFactory;

public final class BackupServiceMetrics
extends DbMetrics {
    private final Counter successfulBackups;
    private final Counter rejectedBackups;
    private final Counter failedBackups;
    private final Counter successfulRestores;
    private final Counter rejectedRestores;
    private final Counter failedRestores;
    private final Gauge<List<String>> runningOperations;
    private final Gauge<List<String>> scheduledOperations;
    private final Gauge<List<String>> scheduledForRetryOperations;
    private final Meter uploadRate;
    private final Meter downloadRate;
    private volatile Map<String, BackupConfigurationMetrics> backupConfigurationMetrics = Collections.emptyMap();
    private volatile Map<String, BackupStoreMetrics> blobStoreMetrics = Collections.emptyMap();

    public BackupServiceMetrics(OperationExecutor operationExecutor) {
        super(new ScopedMetricNameFactory("BackupRestoreService"));
        this.successfulBackups = this.registerCompositeCounter("SuccessfulBackups", () -> this.backupConfigurationMetrics.values().stream().map(c -> ((BackupConfigurationMetrics)c).successfulBackups));
        this.failedBackups = this.registerCompositeCounter("FailedBackups", () -> this.backupConfigurationMetrics.values().stream().map(c -> ((BackupConfigurationMetrics)c).failedBackups));
        this.rejectedBackups = this.registerCompositeCounter("RejectedBackups", () -> this.backupConfigurationMetrics.values().stream().map(c -> ((BackupConfigurationMetrics)c).rejectedBackups));
        this.successfulRestores = this.registerCounter("SuccessfulRestores");
        this.rejectedRestores = this.registerCounter("RejectedRestores");
        this.failedRestores = this.registerCounter("FailedRestores");
        this.downloadRate = this.registerCompositeMeter("DownloadRate", () -> this.blobStoreMetrics.values().stream().map(m -> ((BackupStoreMetrics)m).downloadRate));
        this.uploadRate = this.registerCompositeMeter("UploadRate", () -> this.blobStoreMetrics.values().stream().map(m -> ((BackupStoreMetrics)m).uploadRate));
        this.runningOperations = this.registerGauge("RunningOperations", () -> ((OperationExecutor)operationExecutor).getRunningOperationIds());
        this.scheduledOperations = this.registerGauge("ScheduledOperations", () -> ((OperationExecutor)operationExecutor).getScheduledOperationIds());
        this.scheduledForRetryOperations = this.registerGauge("ScheduledForRetryOperations", () -> ((OperationExecutor)operationExecutor).getScheduledForRetryOperationIds());
    }

    public synchronized void createdOrUpdatedBackupConfiguration(BackupConfiguration backupConfiguration) {
        HashMap<String, BackupConfigurationMetrics> copy = new HashMap<String, BackupConfigurationMetrics>(this.backupConfigurationMetrics);
        String configurationName = backupConfiguration.getName();
        BackupConfigurationMetrics configurationMetrics = (BackupConfigurationMetrics)copy.remove(configurationName);
        configurationMetrics = configurationMetrics == null ? new BackupConfigurationMetrics(backupConfiguration) : configurationMetrics.updateStores(backupConfiguration.getStoreNames());
        copy.put(configurationName, configurationMetrics);
        this.backupConfigurationMetrics = copy;
    }

    public synchronized void removedBackupConfiguration(String configurationName) {
        HashMap<String, BackupConfigurationMetrics> copy = new HashMap<String, BackupConfigurationMetrics>(this.backupConfigurationMetrics);
        BackupConfigurationMetrics toRelease = (BackupConfigurationMetrics)copy.remove(configurationName);
        this.backupConfigurationMetrics = copy;
        BackupServiceMetrics.release(toRelease);
    }

    private static void releaseAll(Map<String, ? extends DbMetrics> metricsMap) {
        metricsMap.forEach((k, v) -> v.release());
    }

    private static void release(DbMetrics metrics) {
        if (metrics != null) {
            metrics.release();
        }
    }

    public synchronized void createdOrUpdatedBackupStore(String storeName) {
        if (!this.blobStoreMetrics.containsKey(storeName)) {
            HashMap<String, BackupStoreMetrics> copy = new HashMap<String, BackupStoreMetrics>(this.blobStoreMetrics);
            copy.put(storeName, new BackupStoreMetrics(storeName));
            this.blobStoreMetrics = copy;
        }
    }

    public synchronized void removedStoreMetrics(String storeName) {
        HashMap<String, BackupStoreMetrics> copy = new HashMap<String, BackupStoreMetrics>(this.blobStoreMetrics);
        BackupStoreMetrics toRelease = (BackupStoreMetrics)copy.remove(storeName);
        this.blobStoreMetrics = copy;
        BackupServiceMetrics.release(toRelease);
    }

    @Override
    public void release() {
        super.release();
        this.clearStoreMetrics();
        this.clearBackupConfigurationMetrics();
    }

    public synchronized void clearBackupConfigurationMetrics() {
        Map<String, BackupConfigurationMetrics> toRelease = this.backupConfigurationMetrics;
        this.backupConfigurationMetrics = Collections.emptyMap();
        BackupServiceMetrics.releaseAll(toRelease);
    }

    public synchronized void clearStoreMetrics() {
        Map<String, BackupStoreMetrics> toRelease = this.blobStoreMetrics;
        this.blobStoreMetrics = Collections.emptyMap();
        BackupServiceMetrics.releaseAll(toRelease);
    }

    public void onSuccessfulOperation(Operation operation) {
        switch (operation.getType()) {
            case BACKUP: {
                this.updateBackupConfigurationMetricIfPresent(operation.getName(), b -> ((BackupConfigurationMetrics)b).successfulBackups.inc());
                break;
            }
            case RESTORE: {
                this.successfulRestores.inc();
                break;
            }
        }
    }

    public void onFailedOperation(Operation operation) {
        switch (operation.getType()) {
            case BACKUP: {
                this.updateBackupConfigurationMetricIfPresent(operation.getName(), b -> ((BackupConfigurationMetrics)b).failedBackups.inc());
                break;
            }
            case RESTORE: {
                this.failedRestores.inc();
                break;
            }
        }
    }

    public void onRejectedOperation(Operation operation) {
        switch (operation.getType()) {
            case BACKUP: {
                this.updateBackupConfigurationMetricIfPresent(operation.getName(), b -> ((BackupConfigurationMetrics)b).rejectedBackups.inc());
                break;
            }
            case RESTORE: {
                this.rejectedRestores.inc();
                break;
            }
        }
    }

    public void trackFileUpload(String configuration, String store, long sizeInBytes) {
        this.updateBackupConfigurationMetricIfPresent(configuration, configurationMetrics -> configurationMetrics.trackFileUpload(store, sizeInBytes));
        this.updateBlobStoreMetricIfPresent(store, backupStoreMetrics -> backupStoreMetrics.trackFileUpload(sizeInBytes));
    }

    public void trackFileDownload(String storeName, long sizeInBytes) {
        this.updateBlobStoreMetricIfPresent(storeName, backupStoreMetrics -> backupStoreMetrics.trackFileDownload(sizeInBytes));
    }

    public void trackFinishedBackupTask(String configurationName, BackupTaskMetrics.Snapshot taskMetrics) {
        this.updateBackupConfigurationMetricIfPresent(configurationName, configurationMetrics -> configurationMetrics.updateMetrics(taskMetrics));
    }

    private void updateBackupConfigurationMetricIfPresent(String backupConfigurationName, Consumer<BackupConfigurationMetrics> consumer) {
        BackupConfigurationMetrics configurationMetrics = this.backupConfigurationMetrics.get(backupConfigurationName);
        if (configurationMetrics != null) {
            consumer.accept(configurationMetrics);
        }
    }

    private void updateBlobStoreMetricIfPresent(String storeName, Consumer<BackupStoreMetrics> consumer) {
        BackupStoreMetrics storeMetrics = this.blobStoreMetrics.get(storeName);
        if (storeMetrics != null) {
            consumer.accept(storeMetrics);
        }
    }

    @VisibleForTesting
    Multimap<String, String> getRegisteredConfigurations() {
        HashMultimap registeredConfigurations = HashMultimap.create();
        for (Map.Entry<String, BackupConfigurationMetrics> backupConfigurationMetricsEntry : this.backupConfigurationMetrics.entrySet()) {
            Set stores = backupConfigurationMetricsEntry.getValue().configurationStoreMetrics.keySet();
            registeredConfigurations.putAll((Object)backupConfigurationMetricsEntry.getKey(), stores);
        }
        return registeredConfigurations;
    }

    @VisibleForTesting
    Set<String> getRegisteredStores() {
        return this.blobStoreMetrics.keySet();
    }

    private static class ScopedMetricNameFactory
    implements MetricNameFactory {
        private static final String JMX_GROUP = "com.datastax.backups";
        private final String type;
        @Nullable
        private final String parent;
        @Nullable
        private final String child;

        public ScopedMetricNameFactory(String type) {
            this(type, null);
        }

        public ScopedMetricNameFactory(String type, String parent) {
            this(type, parent, null);
        }

        public ScopedMetricNameFactory(String type, @Nullable String parent, @Nullable String child) {
            assert (parent != null || child == null) : "Can't have a child scope metric without a parent";
            this.type = type;
            this.parent = parent;
            this.child = child;
        }

        @Override
        public CassandraMetricsRegistry.MetricName createMetricName(String metricName) {
            String metricScope = this.child != null ? this.parent + "." + this.child : this.parent;
            return new CassandraMetricsRegistry.MetricName(JMX_GROUP, this.type, metricName, metricScope, this.createMBeanName(metricName));
        }

        private String createMBeanName(String name) {
            StringBuilder builder = new StringBuilder().append(JMX_GROUP).append(":type=").append(this.type);
            if (this.parent != null) {
                builder.append(",parent=").append(this.parent);
                if (this.child != null) {
                    builder.append(",child=").append(this.child);
                }
            }
            if (name.length() > 0) {
                builder.append(",name=").append(name);
            }
            return builder.toString();
        }
    }

    private static class BackupStoreMetrics
    extends DbMetrics {
        private final Meter uploadRate = this.registerMeter("UploadRate");
        private final Meter downloadRate = this.registerMeter("DownloadRate");
        private final Counter uploadedData = this.registerCounter("UploadedData");
        private final Counter uploadedFiles = this.registerCounter("UploadedSSTables");

        BackupStoreMetrics(String storeName) {
            super(new ScopedMetricNameFactory("BackupStore", storeName));
        }

        void trackFileUpload(long sizeInBytes) {
            this.uploadRate.mark(sizeInBytes);
            this.uploadedData.inc(sizeInBytes);
            this.uploadedFiles.inc();
        }

        void trackFileDownload(long sizeInBytes) {
            this.downloadRate.mark(sizeInBytes);
        }
    }

    private static class BackupConfigurationMetrics
    extends DbMetrics {
        private final Counter successfulBackups;
        private final Counter rejectedBackups;
        private final Counter failedBackups;
        private final Counter uploadedData;
        private final Counter uploadedFiles;
        private final Histogram backupDuration;
        private final Histogram backedSSTables;
        private final String configurationName;
        private final Map<String, BackupConfigurationStoreMetrics> configurationStoreMetrics;

        BackupConfigurationMetrics(BackupConfiguration backupConfiguration) {
            super(new ScopedMetricNameFactory("BackupConfiguration", backupConfiguration.getName()));
            this.configurationName = backupConfiguration.getName();
            this.successfulBackups = this.registerCounter("SuccessfulBackups");
            this.rejectedBackups = this.registerCounter("RejectedBackups");
            this.failedBackups = this.registerCounter("FailedBackups");
            this.uploadedData = this.registerCounter("UploadedData");
            this.uploadedFiles = this.registerCounter("UploadedFiles");
            this.backupDuration = this.registerHistogram("Duration", true);
            this.backedSSTables = this.registerHistogram("BackedSSTables", true);
            this.configurationStoreMetrics = new HashMap<String, BackupConfigurationStoreMetrics>(backupConfiguration.getStoreNames().size());
            for (String storeName : backupConfiguration.getStoreNames()) {
                this.configurationStoreMetrics.put(storeName, new BackupConfigurationStoreMetrics(this.configurationName, storeName));
            }
        }

        BackupConfigurationMetrics(BackupConfigurationMetrics original, Map<String, BackupConfigurationStoreMetrics> newConfigurationStoreMetrics) {
            super(original);
            this.configurationName = original.configurationName;
            this.successfulBackups = original.successfulBackups;
            this.rejectedBackups = original.rejectedBackups;
            this.failedBackups = original.failedBackups;
            this.uploadedData = original.uploadedData;
            this.uploadedFiles = original.uploadedFiles;
            this.backupDuration = original.backupDuration;
            this.backedSSTables = original.backedSSTables;
            this.configurationStoreMetrics = newConfigurationStoreMetrics;
        }

        BackupConfigurationMetrics updateStores(List<String> storeNames) {
            HashMap<String, BackupConfigurationStoreMetrics> copy = new HashMap<String, BackupConfigurationStoreMetrics>(this.configurationStoreMetrics);
            ArrayList toRelease = new ArrayList();
            for (String storeName : new HashSet(copy.keySet())) {
                if (storeNames.contains(storeName)) continue;
                toRelease.add(copy.remove(storeName));
            }
            for (String storeName : storeNames) {
                copy.putIfAbsent(storeName, new BackupConfigurationStoreMetrics(this.configurationName, storeName));
            }
            toRelease.forEach(DbMetrics::release);
            return new BackupConfigurationMetrics(this, copy);
        }

        @Override
        public void release() {
            super.release();
            this.configurationStoreMetrics.values().forEach(DbMetrics::release);
        }

        void trackFileUpload(String storeName, long sizeInBytes) {
            BackupConfigurationStoreMetrics backupConfigurationStoreMetrics = this.configurationStoreMetrics.get(storeName);
            if (backupConfigurationStoreMetrics != null) {
                backupConfigurationStoreMetrics.updateDataUploaded(sizeInBytes);
            }
            this.uploadedData.inc(sizeInBytes);
            this.uploadedFiles.inc();
        }

        void updateMetrics(BackupTaskMetrics.Snapshot taskMetrics) {
            this.backupDuration.update(taskMetrics.getBackupDurationInMillis());
            this.backedSSTables.update(taskMetrics.getSnapshottedSstables());
        }

        private static class BackupConfigurationStoreMetrics
        extends DbMetrics {
            private final Meter uploadRate = this.registerMeter("UploadRate");
            private final Counter dataUploaded = this.registerCounter("DataUploaded");
            private final Counter filesUploaded = this.registerCounter("FilesUploaded");

            private BackupConfigurationStoreMetrics(String configurationName, String storeName) {
                super(new ScopedMetricNameFactory("BackupConfiguration", configurationName, storeName));
            }

            void updateDataUploaded(long bytes) {
                this.uploadRate.mark(bytes);
                this.dataUploaded.inc(bytes);
                this.filesUploaded.inc();
            }
        }
    }
}

