/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import java.util.stream.Stream;
import org.apache.cassandra.metrics.Composable;
import org.apache.cassandra.metrics.Meter;

abstract class BaseCompositeMeter
extends Meter {
    BaseCompositeMeter() {
    }

    @Override
    public void mark(long n) {
        throw new UnsupportedOperationException("Composite meters are read-only");
    }

    protected abstract Stream<Meter> metersStream();

    @Override
    public final long getCount() {
        return this.metersStream().map(Meter::getCount).reduce(0L, Long::sum);
    }

    @Override
    public final double getFifteenMinuteRate() {
        return this.metersStream().map(Meter::getFifteenMinuteRate).reduce(0.0, Double::sum);
    }

    @Override
    public final double getFiveMinuteRate() {
        return this.metersStream().map(Meter::getFiveMinuteRate).reduce(0.0, Double::sum);
    }

    @Override
    public final double getMeanRate() {
        return this.metersStream().map(Meter::getMeanRate).reduce(0.0, Double::sum);
    }

    @Override
    public final double getOneMinuteRate() {
        return this.metersStream().map(Meter::getOneMinuteRate).reduce(0.0, Double::sum);
    }

    @Override
    public final Composable.Type getType() {
        return Composable.Type.COMPOSITE;
    }

    @Override
    public void compose(Meter metric) {
        throw new UnsupportedOperationException();
    }
}

