/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Gauge;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.Meter;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.utils.memory.buffers.BufferPool;

public class BufferPoolMetrics {
    private final MetricNameFactory factory;
    public final Meter overflowAllocs;
    public final Gauge<Long> totalSize;
    public final Gauge<Long> overflowSize;
    public final Gauge<Long> usedSize;

    public BufferPoolMetrics(String name, BufferPool bufferPool) {
        this.factory = new DefaultNameFactory(name);
        this.totalSize = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("Size"), () -> ((BufferPool)bufferPool).allocatedMemoryBytes());
        this.usedSize = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("UsedSize"), () -> ((BufferPool)bufferPool).usedMemoryBytes());
        this.overflowSize = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("OverflowSize"), () -> ((BufferPool)bufferPool).overflowMemoryBytes());
        this.overflowAllocs = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName("OverflowAllocations"));
    }

    public static void registerLegacyAliases(String aliasName, BufferPoolMetrics cachedReadsMetrics, BufferPoolMetrics directReadsMetrics) {
        DefaultNameFactory aliasFactory = new DefaultNameFactory(aliasName);
        CassandraMetricsRegistry.Metrics.registerAlias(cachedReadsMetrics.factory.createMetricName("Size"), aliasFactory.createMetricName("Size"));
        CassandraMetricsRegistry.Metrics.registerAlias(cachedReadsMetrics.factory.createMetricName("UsedSize"), aliasFactory.createMetricName("UsedSize"));
        CassandraMetricsRegistry.Metrics.registerAlias(cachedReadsMetrics.factory.createMetricName("OverflowSize"), aliasFactory.createMetricName("OverflowSize"));
        CassandraMetricsRegistry.Metrics.registerAlias(cachedReadsMetrics.factory.createMetricName("OverflowAllocations"), aliasFactory.createMetricName("Misses"));
        CassandraMetricsRegistry.Metrics.registerAlias(directReadsMetrics.factory.createMetricName("Size"), aliasFactory.createMetricName("ChunkReaderBufferSize"));
    }
}

