/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.RatioGauge;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.Counter;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;

public class CQLMetrics {
    private static final MetricNameFactory factory = new DefaultNameFactory("CQL");
    public final Counter regularStatementsExecuted = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("RegularStatementsExecuted"));
    public final Counter preparedStatementsExecuted = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("PreparedStatementsExecuted"));
    public final Counter preparedStatementsEvicted = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("PreparedStatementsEvicted"));
    public final Gauge<Integer> preparedStatementsCount = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("PreparedStatementsCount"), new Gauge<Integer>(){

        public Integer getValue() {
            return QueryProcessor.preparedStatementsCount();
        }
    });
    public final Gauge<Double> preparedStatementsRatio = (Gauge)CassandraMetricsRegistry.Metrics.register(factory.createMetricName("PreparedStatementsRatio"), new RatioGauge(){

        public RatioGauge.Ratio getRatio() {
            return RatioGauge.Ratio.of((double)this.getNumerator(), (double)this.getDenominator());
        }

        public double getNumerator() {
            return CQLMetrics.this.preparedStatementsExecuted.getCount();
        }

        public double getDenominator() {
            return CQLMetrics.this.regularStatementsExecuted.getCount() + CQLMetrics.this.preparedStatementsExecuted.getCount();
        }
    });
}

