/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import java.util.function.DoubleSupplier;
import org.apache.cassandra.cache.CacheSize;
import org.apache.cassandra.db.virtual.CachesSystemView;
import org.apache.cassandra.db.virtual.InMemoryVirtualTable;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.Meter;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.metrics.Timer;

public class CacheMetrics {
    public final Gauge<Long> capacity;
    public final Meter hits;
    public final Meter misses;
    public final Meter requests;
    public final Gauge<Double> hitRate;
    public final Gauge<Double> oneMinuteHitRate;
    public final Gauge<Double> fiveMinuteHitRate;
    public final Gauge<Double> fifteenMinuteHitRate;
    public final Gauge<Long> size;
    public final Gauge<Integer> entries;
    public final String cacheType;
    private final MetricNameFactory factory;

    public CacheMetrics(String type, CacheSize cache) {
        this.cacheType = type;
        this.factory = new DefaultNameFactory("Cache", type);
        this.capacity = this.registerGauge("Capacity", () -> ((CacheSize)cache).capacity());
        this.size = this.registerGauge("Size", () -> ((CacheSize)cache).weightedSize());
        this.entries = this.registerGauge("Entries", () -> ((CacheSize)cache).size());
        this.requests = this.registerMeter("Requests", true);
        this.hits = this.registerMeter("Hits");
        this.requests.compose((Metric)this.hits);
        this.misses = this.registerMeter("Misses");
        this.requests.compose((Metric)this.misses);
        this.hitRate = this.registerGauge("HitRate", CacheMetrics.ratioGauge(this.hits::getCount, this.requests::getCount));
        this.oneMinuteHitRate = this.registerGauge("OneMinuteHitRate", CacheMetrics.ratioGauge(this.hits::getOneMinuteRate, this.requests::getOneMinuteRate));
        this.fiveMinuteHitRate = this.registerGauge("FiveMinuteHitRate", CacheMetrics.ratioGauge(this.hits::getFiveMinuteRate, this.requests::getFiveMinuteRate));
        this.fifteenMinuteHitRate = this.registerGauge("FifteenMinuteHitRate", CacheMetrics.ratioGauge(this.hits::getFifteenMinuteRate, this.requests::getFifteenMinuteRate));
        ((InMemoryVirtualTable)CachesSystemView.INSTANCE).addRowData((Object)this);
    }

    private static double ratio(double numerator, double denominator) {
        if (Double.isNaN(denominator) || Double.isInfinite(denominator) || denominator == 0.0) {
            return Double.NaN;
        }
        return numerator / denominator;
    }

    protected final <T> Gauge<T> registerGauge(String name, Gauge<T> gauge) {
        return CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName(name), gauge);
    }

    protected final Meter registerMeter(String name, boolean composite) {
        return CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName(name), composite);
    }

    protected final Meter registerMeter(String name) {
        return this.registerMeter(name, false);
    }

    protected final Timer registerTimer(String name) {
        return CassandraMetricsRegistry.Metrics.timer(this.factory.createMetricName(name));
    }

    public static Gauge<Double> ratioGauge(DoubleSupplier numeratorSupplier, DoubleSupplier denominatorSupplier) {
        return () -> CacheMetrics.ratio(numeratorSupplier.getAsDouble(), denominatorSupplier.getAsDouble());
    }
}

