/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.lang.reflect.Method;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.cassandra.metrics.Counter;
import org.apache.cassandra.metrics.Histogram;
import org.apache.cassandra.metrics.Meter;
import org.apache.cassandra.metrics.Timer;

public class CassandraMetricsRegistry
extends MetricRegistry {
    public static volatile MetricRegistry actualRegistry = new MetricRegistry();
    public static final CassandraMetricsRegistry Metrics = new CassandraMetricsRegistry();

    private CassandraMetricsRegistry() {
    }

    public Counter counter(MetricName name, boolean isComposite) {
        return this.register(name, Counter.make(isComposite));
    }

    public Counter counter(MetricName name) {
        return this.counter(name, false);
    }

    public Counter counter(MetricName name, MetricName alias, boolean isComposite) {
        return this.counter(name, isComposite);
    }

    public Meter meter(MetricName name) {
        return this.register(name, Meter.makeSingle());
    }

    public Meter meter(MetricName name, boolean isComposite) {
        return this.register(name, isComposite ? Meter.makeComposite() : Meter.makeSingle());
    }

    public Meter meter(MetricName name, MetricName alias) {
        return this.meter(name);
    }

    public Histogram histogram(MetricName name, boolean considerZeroes) {
        return this.histogram(name, considerZeroes, false);
    }

    public Histogram histogram(MetricName name, boolean considerZeroes, boolean isComposite) {
        return this.register(name, Histogram.make(considerZeroes, isComposite));
    }

    public Histogram histogram(MetricName name, MetricName alias, boolean considerZeroes, boolean isComposite) {
        return this.histogram(name, considerZeroes, isComposite);
    }

    public Timer timer(MetricName name, boolean isComposite) {
        return this.register(name, new Timer(isComposite));
    }

    public Timer timer(MetricName name) {
        return this.timer(name, false);
    }

    public Timer timer(MetricName name, MetricName alias, boolean isComposite) {
        return this.timer(name, isComposite);
    }

    public <T extends Metric> T register(MetricName name, T metric) {
        try {
            return (T)actualRegistry.register(name.getMetricName(), metric);
        }
        catch (IllegalArgumentException e) {
            Metric existing = (Metric)actualRegistry.getMetrics().get(name.getMetricName());
            return (T)existing;
        }
    }

    public <T extends Metric> T register(MetricName name, MetricName aliasName, T metric) {
        return this.register(name, metric);
    }

    public boolean remove(MetricName name) {
        return actualRegistry.remove(name.getMetricName());
    }

    public boolean remove(MetricName name, MetricName alias) {
        return this.remove(name);
    }

    public void registerMBean(Metric metric, ObjectName name) {
    }

    public void registerAlias(MetricName existingName, MetricName aliasName) {
    }

    private static String withoutFinalDollar(String s) {
        int l = s.length();
        return l != 0 && '$' == s.charAt(l - 1) ? s.substring(0, l - 1) : s;
    }

    public static final class MetricName
    implements Comparable<MetricName> {
        private final String group;
        private final String type;
        private final String name;
        private final String scope;
        private final String mBeanName;

        public MetricName(Class<?> klass, String name) {
            this(klass, name, null);
        }

        public MetricName(String group, String type, String name) {
            this(group, type, name, null);
        }

        public MetricName(Class<?> klass, String name, String scope) {
            this(klass.getPackage() == null ? "" : klass.getPackage().getName(), CassandraMetricsRegistry.withoutFinalDollar(klass.getSimpleName()), name, scope);
        }

        public MetricName(String group, String type, String name, String scope) {
            this(group, type, name, scope, MetricName.createMBeanName(group, type, name, scope));
        }

        public MetricName(String group, String type, String name, String scope, String mBeanName) {
            if (group == null || type == null) {
                throw new IllegalArgumentException("Both group and type need to be specified");
            }
            if (name == null) {
                throw new IllegalArgumentException("Name needs to be specified");
            }
            this.group = group;
            this.type = type;
            this.name = name;
            this.scope = scope;
            this.mBeanName = mBeanName;
        }

        public String getGroup() {
            return this.group;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getMetricName() {
            return MetricRegistry.name((String)this.group, (String[])new String[]{this.type, this.name, this.scope});
        }

        public String getScope() {
            return this.scope;
        }

        public boolean hasScope() {
            return this.scope != null;
        }

        public ObjectName getMBeanName() {
            String mname = this.mBeanName;
            if (mname == null) {
                mname = this.getMetricName();
            }
            try {
                return new ObjectName(mname);
            }
            catch (MalformedObjectNameException e) {
                try {
                    return new ObjectName(ObjectName.quote(mname));
                }
                catch (MalformedObjectNameException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetricName that = (MetricName)o;
            return this.mBeanName.equals(that.mBeanName);
        }

        public int hashCode() {
            return this.mBeanName.hashCode();
        }

        public String toString() {
            return this.mBeanName;
        }

        @Override
        public int compareTo(MetricName o) {
            return this.mBeanName.compareTo(o.mBeanName);
        }

        private static String createMBeanName(String group, String type, String name, String scope) {
            StringBuilder nameBuilder = new StringBuilder();
            nameBuilder.append(ObjectName.quote(group));
            nameBuilder.append(":type=");
            nameBuilder.append(ObjectName.quote(type));
            if (scope != null) {
                nameBuilder.append(",scope=");
                nameBuilder.append(ObjectName.quote(scope));
            }
            if (name.length() > 0) {
                nameBuilder.append(",name=");
                nameBuilder.append(ObjectName.quote(name));
            }
            return nameBuilder.toString();
        }

        public static String chooseGroup(String group, Class<?> klass) {
            if (group == null || group.isEmpty()) {
                group = klass.getPackage() == null ? "" : klass.getPackage().getName();
            }
            return group;
        }

        public static String chooseType(String type, Class<?> klass) {
            if (type == null || type.isEmpty()) {
                type = CassandraMetricsRegistry.withoutFinalDollar(klass.getSimpleName());
            }
            return type;
        }

        public static String chooseName(String name, Method method) {
            if (name == null || name.isEmpty()) {
                name = method.getName();
            }
            return name;
        }
    }

    public static interface JmxTimerMBean
    extends JmxMeterMBean {
        public double getMin();

        public double getMax();

        public double getMean();

        public double getStdDev();

        public double get50thPercentile();

        public double get75thPercentile();

        public double get95thPercentile();

        public double get98thPercentile();

        public double get99thPercentile();

        public double get999thPercentile();

        public long[] values();

        public long[] getRecentValues();

        public String getDurationUnit();
    }

    public static interface JmxMeterMBean
    extends MetricMBean {
        public long getCount();

        public double getMeanRate();

        public double getOneMinuteRate();

        public double getFiveMinuteRate();

        public double getFifteenMinuteRate();

        public String getRateUnit();
    }

    public static interface JmxCounterMBean
    extends MetricMBean {
        public long getCount();
    }

    public static interface JmxHistogramMBean
    extends MetricMBean {
        public long getCount();

        public long getMin();

        public long getMax();

        public double getMean();

        public double getStdDev();

        public double get50thPercentile();

        public double get75thPercentile();

        public double get95thPercentile();

        public double get98thPercentile();

        public double get99thPercentile();

        public double get999thPercentile();

        public long[] values();

        public long[] getRecentValues();
    }

    public static interface JmxGaugeMBean
    extends MetricMBean {
        public Object getValue();
    }

    public static interface MetricMBean {
        public ObjectName objectName();
    }
}

