/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Timer;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.cassandra.cache.CacheSize;
import org.apache.cassandra.cache.ChunkCache;
import org.apache.cassandra.metrics.CacheMetrics;
import org.apache.cassandra.metrics.Meter;

public class ChunkCacheMetrics
extends CacheMetrics
implements StatsCounter {
    public final Timer missLatency = this.registerTimer("MissLatency");
    public final Meter notInCacheExceptions = this.registerMeter("NotInCacheExceptions");

    public ChunkCacheMetrics(ChunkCache cache) {
        super("ChunkCache", (CacheSize)cache);
    }

    public void recordHits(int count) {
        this.hits.mark(count);
    }

    public void recordMisses(int count) {
        this.misses.mark(count);
    }

    public void recordLoadSuccess(long loadTime) {
        this.missLatency.update(loadTime, TimeUnit.NANOSECONDS);
    }

    public void recordLoadFailure(long loadTime) {
    }

    public void recordEviction() {
    }

    @Nonnull
    public CacheStats snapshot() {
        return new CacheStats(this.hits.getCount(), this.misses.getCount(), this.missLatency.getCount(), 0L, this.missLatency.getCount(), 0L, 0L);
    }

    @VisibleForTesting
    public void reset() {
        this.hits.mark(-this.hits.getCount());
        this.misses.mark(-this.misses.getCount());
    }
}

