/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.CachedGauge;
import com.codahale.metrics.DerivativeGauge;
import com.codahale.metrics.Gauge;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.compaction.AbstractTableOperation;
import org.apache.cassandra.db.compaction.CompactionAggregateStatistics;
import org.apache.cassandra.db.compaction.CompactionStrategyStatistics;
import org.apache.cassandra.db.compaction.TableOperation;
import org.apache.cassandra.db.compaction.TableOperationObserver;
import org.apache.cassandra.db.compaction.TableOperations;
import org.apache.cassandra.exceptions.UnknownTableException;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.Counter;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.Meter;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.schema.SchemaChangeListener;
import org.apache.cassandra.schema.SchemaManager;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.MapsFactory;
import org.apache.cassandra.utils.NonThrowingCloseable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionMetrics
implements TableOperationObserver,
SchemaChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(CompactionMetrics.class);
    public static final MetricNameFactory factory = new DefaultNameFactory("Compaction");
    private static final ConcurrentMap<String, TableOperations> operationsByTable = new ConcurrentHashMap<String, TableOperations>();
    public final Gauge<Integer> pendingTasks;
    public final Gauge<Map<String, Map<String, Integer>>> pendingTasksByTableName;
    public final Gauge<Map<String, Map<String, Double>>> writeAmplificationByTableName;
    public final Gauge<Long> completedTasks;
    public final Meter totalCompactionsCompleted;
    public final Counter bytesCompacted;
    public final CachedGauge<List<CompactionStrategyStatistics>> aggregateCompactions;
    public final DerivativeGauge<List<CompactionStrategyStatistics>, Integer> runningCompactions;
    public final DerivativeGauge<List<CompactionStrategyStatistics>, Double> meanCompactionReadThroughput;
    public final DerivativeGauge<List<CompactionStrategyStatistics>, Double> meanCompactionWriteThroughput;
    public final DerivativeGauge<List<CompactionStrategyStatistics>, Long> runningCompactionsTotalBytes;
    public final DerivativeGauge<List<CompactionStrategyStatistics>, Long> runningCompactionsRemainingBytes;
    public final Counter compactionsReduced;
    public final Counter sstablesDropppedFromCompactions;
    public final Counter compactionsAborted;
    public final Meter removedExpiredSSTables;
    public final Meter deleteOnlyCompactions;

    public CompactionMetrics(ThreadPoolExecutor ... collectors) {
        SchemaManager.instance.registerListener((SchemaChangeListener)this);
        this.pendingTasks = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("PendingTasks"), () -> {
            int n = 0;
            for (String keyspaceName : SchemaManager.instance.getKeyspaces()) {
                for (ColumnFamilyStore cfs : Keyspace.open((String)keyspaceName).getColumnFamilyStores()) {
                    n += cfs.getCompactionStrategy().getEstimatedRemainingTasks();
                }
            }
            return n + CompactionMetrics.getTableOperations().size();
        });
        this.pendingTasksByTableName = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("PendingTasksByTableName"), () -> {
            Map resultMap = MapsFactory.newMap();
            for (String keyspaceName : SchemaManager.instance.getKeyspaces()) {
                for (ColumnFamilyStore cfs : Keyspace.open((String)keyspaceName).getColumnFamilyStores()) {
                    int taskNumber = cfs.getCompactionStrategy().getEstimatedRemainingTasks();
                    if (taskNumber <= 0) continue;
                    if (!resultMap.containsKey(keyspaceName)) {
                        resultMap.put(keyspaceName, MapsFactory.newMap());
                    }
                    ((Map)resultMap.get(keyspaceName)).put(cfs.getTableName(), taskNumber);
                }
            }
            for (TableOperation op : CompactionMetrics.getTableOperations()) {
                Map tableNameToCountMap;
                TableMetadata metaData = op.getProgress().metadata();
                if (metaData == null) continue;
                if (!resultMap.containsKey(metaData.keyspace)) {
                    resultMap.put(metaData.keyspace, MapsFactory.newMap());
                }
                if ((tableNameToCountMap = (Map)resultMap.get(metaData.keyspace)).containsKey(metaData.name)) {
                    tableNameToCountMap.put(metaData.name, (Integer)tableNameToCountMap.get(metaData.name) + 1);
                    continue;
                }
                tableNameToCountMap.put(metaData.name, 1);
            }
            return resultMap;
        });
        this.writeAmplificationByTableName = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("WriteAmplificationByTableName"), () -> {
            Map resultMap = MapsFactory.newMap();
            for (String keyspaceName : SchemaManager.instance.getKeyspaces()) {
                Map ksMap = MapsFactory.newMap();
                resultMap.put(keyspaceName, ksMap);
                for (ColumnFamilyStore cfs : Keyspace.open((String)keyspaceName).getColumnFamilyStores()) {
                    ksMap.put(cfs.getTableName(), cfs.getWA());
                }
            }
            return resultMap;
        });
        this.completedTasks = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("CompletedTasks"), () -> {
            long completedTasks = 0L;
            for (ThreadPoolExecutor collector : collectors) {
                completedTasks += collector.getCompletedTaskCount();
            }
            return completedTasks;
        });
        this.totalCompactionsCompleted = CassandraMetricsRegistry.Metrics.meter(factory.createMetricName("TotalCompactionsCompleted"));
        this.bytesCompacted = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("BytesCompacted"));
        this.compactionsReduced = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("CompactionsReduced"));
        this.sstablesDropppedFromCompactions = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("SSTablesDroppedFromCompaction"));
        this.compactionsAborted = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("CompactionsAborted"));
        this.removedExpiredSSTables = CassandraMetricsRegistry.Metrics.meter(factory.createMetricName("ExpiredSSTablesDropped"));
        this.deleteOnlyCompactions = CassandraMetricsRegistry.Metrics.meter(factory.createMetricName("DeleteOnlyCompactions"));
        this.aggregateCompactions = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("AggregateCompactions"), new CachedGauge<List<CompactionStrategyStatistics>>(50L, TimeUnit.MILLISECONDS){

            protected List<CompactionStrategyStatistics> loadValue() {
                ArrayList<CompactionStrategyStatistics> ret = new ArrayList<CompactionStrategyStatistics>();
                for (String keyspaceName : SchemaManager.instance.getKeyspaces()) {
                    for (ColumnFamilyStore cfs : Keyspace.open((String)keyspaceName).getColumnFamilyStores()) {
                        ret.addAll(cfs.getCompactionStrategy().getStatistics());
                    }
                }
                return ret;
            }
        });
        this.runningCompactions = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("RunningCompactions"), new DerivativeGauge<List<CompactionStrategyStatistics>, Integer>(this.aggregateCompactions){

            protected Integer transform(List<CompactionStrategyStatistics> value) {
                return CompactionMetrics.deriveSafeAggregateStatisticsStream(value).mapToInt(CompactionAggregateStatistics::numCompactionsInProgress).sum();
            }
        });
        this.meanCompactionReadThroughput = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("MeanCompactionReadThroughput"), new DerivativeGauge<List<CompactionStrategyStatistics>, Double>(this.aggregateCompactions){

            protected Double transform(List<CompactionStrategyStatistics> value) {
                return CompactionMetrics.deriveSafeAggregateStatisticsStream(value).filter(s -> s.numCompactionsInProgress() > 0).mapToDouble(CompactionAggregateStatistics::readThroughput).average().orElse(0.0);
            }
        });
        this.meanCompactionWriteThroughput = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("MeanCompactionWriteThroughput"), new DerivativeGauge<List<CompactionStrategyStatistics>, Double>(this.aggregateCompactions){

            protected Double transform(List<CompactionStrategyStatistics> value) {
                return CompactionMetrics.deriveSafeAggregateStatisticsStream(value).filter(s -> s.numCompactionsInProgress() > 0).mapToDouble(CompactionAggregateStatistics::writeThroughput).average().orElse(0.0);
            }
        });
        this.runningCompactionsTotalBytes = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("RunningCompactionsTotalBytes"), new DerivativeGauge<List<CompactionStrategyStatistics>, Long>(this.aggregateCompactions){

            protected Long transform(List<CompactionStrategyStatistics> value) {
                return CompactionMetrics.deriveSafeAggregateStatisticsStream(value).mapToLong(CompactionAggregateStatistics::tot).sum();
            }
        });
        this.runningCompactionsRemainingBytes = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("RunningCompactionsRemainingBytes"), new DerivativeGauge<List<CompactionStrategyStatistics>, Long>(this.aggregateCompactions){

            protected Long transform(List<CompactionStrategyStatistics> value) {
                return CompactionMetrics.deriveSafeAggregateStatisticsStream(value).mapToLong(s -> s.tot() - s.read()).sum();
            }
        });
    }

    private static Stream<CompactionAggregateStatistics> deriveSafeAggregateStatisticsStream(List<CompactionStrategyStatistics> aggregateCompactions) {
        if (aggregateCompactions == null) {
            return Stream.empty();
        }
        return aggregateCompactions.stream().flatMap(s -> s.aggregates().stream());
    }

    public NonThrowingCloseable onOperationStart(TableOperation op) {
        AbstractTableOperation.OperationProgress progress = op.getProgress();
        String key = this.operationsByTableKey((TableOperation.Progress)progress);
        operationsByTable.computeIfAbsent(key, arg_0 -> CompactionMetrics.lambda$onOperationStart$5((TableOperation.Progress)progress, arg_0));
        operationsByTable.computeIfPresent(key, (k, ops) -> ops.operationStarted(op));
        return () -> operationsByTable.computeIfPresent(key, (k, ops) -> ops.operationCompleted(op, (TableOperation.Progress)op.getProgress(), this));
    }

    public TableOperations.Snapshot operationsInProgress(TableMetadata metadata) {
        TableOperations tableOperations = (TableOperations)operationsByTable.get(this.operationsByTableKey(metadata));
        if (tableOperations == null) {
            return null;
        }
        try {
            ColumnFamilyStore cfs = Keyspace.open((String)metadata.keyspace).getColumnFamilyStore(metadata.name);
            return new TableOperations.Snapshot(cfs, tableOperations);
        }
        catch (IllegalArgumentException | UnknownTableException ex) {
            logger.debug("Could not return operations in progress for {}: {}", (Object)metadata, (Object)ex.getMessage());
            return null;
        }
    }

    private String operationsByTableKey(TableOperation.Progress progress) {
        return this.operationsByTableKey(progress.metadata());
    }

    private String operationsByTableKey(TableMetadata metadata) {
        return this.operationsByTableKey(metadata.keyspace, metadata.name);
    }

    private String operationsByTableKey(String keyspace, String table) {
        return keyspace + "." + table;
    }

    public static List<TableOperation> getTableOperations() {
        return operationsByTable.values().stream().flatMap(compactions -> compactions.getInProgress().stream()).collect(Collectors.toList());
    }

    public void onDropTable(String keyspace, String table, TableId tableId) {
        operationsByTable.remove(this.operationsByTableKey(keyspace, table));
    }

    private static /* synthetic */ TableOperations lambda$onOperationStart$5(TableOperation.Progress progress, String k) {
        return new TableOperations(progress.metadata());
    }
}

