/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import java.net.InetAddress;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.net.async.OutboundConnectionIdentifier;
import org.apache.cassandra.net.async.OutboundMessagingPool;

public class ConnectionMetrics {
    public static final String TYPE_NAME = "Connection";
    public static final Meter totalTimeouts = CassandraMetricsRegistry.Metrics.meter(DefaultNameFactory.createMetricName("Connection", "TotalTimeouts", null));
    public final String address;
    public final Gauge<Integer> largeMessagePendingTasks;
    public final Gauge<Long> largeMessageCompletedTasks;
    public final Gauge<Long> largeMessageDroppedTasks;
    public final Gauge<Integer> smallMessagePendingTasks;
    public final Gauge<Long> smallMessageCompletedTasks;
    public final Gauge<Long> smallMessageDroppedTasks;
    public final Gauge<Integer> gossipMessagePendingTasks;
    public final Gauge<Long> gossipMessageCompletedTasks;
    public final Gauge<Long> gossipMessageDroppedTasks;
    public final Meter timeouts;
    private final MetricNameFactory factory;

    public ConnectionMetrics(InetAddress ip, final OutboundMessagingPool messagingPool) {
        this.address = ip.getHostAddress().replace(':', '.');
        this.factory = new DefaultNameFactory(TYPE_NAME, this.address);
        this.largeMessagePendingTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("LargeMessagePendingTasks"), new Gauge<Integer>(){

            public Integer getValue() {
                return messagingPool.getPendingMessages(OutboundConnectionIdentifier.ConnectionType.LARGE_MESSAGE);
            }
        });
        this.largeMessageCompletedTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("LargeMessageCompletedTasks"), new Gauge<Long>(){

            public Long getValue() {
                return messagingPool.getCompletedMessages(OutboundConnectionIdentifier.ConnectionType.LARGE_MESSAGE);
            }
        });
        this.largeMessageDroppedTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("LargeMessageDroppedTasks"), new Gauge<Long>(){

            public Long getValue() {
                return messagingPool.getDroppedMessages(OutboundConnectionIdentifier.ConnectionType.LARGE_MESSAGE);
            }
        });
        this.smallMessagePendingTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("SmallMessagePendingTasks"), new Gauge<Integer>(){

            public Integer getValue() {
                return messagingPool.getPendingMessages(OutboundConnectionIdentifier.ConnectionType.SMALL_MESSAGE);
            }
        });
        this.smallMessageCompletedTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("SmallMessageCompletedTasks"), new Gauge<Long>(){

            public Long getValue() {
                return messagingPool.getCompletedMessages(OutboundConnectionIdentifier.ConnectionType.SMALL_MESSAGE);
            }
        });
        this.smallMessageDroppedTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("SmallMessageDroppedTasks"), new Gauge<Long>(){

            public Long getValue() {
                return messagingPool.getDroppedMessages(OutboundConnectionIdentifier.ConnectionType.SMALL_MESSAGE);
            }
        });
        this.gossipMessagePendingTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("GossipMessagePendingTasks"), new Gauge<Integer>(){

            public Integer getValue() {
                return messagingPool.getPendingMessages(OutboundConnectionIdentifier.ConnectionType.GOSSIP);
            }
        });
        this.gossipMessageCompletedTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("GossipMessageCompletedTasks"), new Gauge<Long>(){

            public Long getValue() {
                return messagingPool.getCompletedMessages(OutboundConnectionIdentifier.ConnectionType.GOSSIP);
            }
        });
        this.gossipMessageDroppedTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("GossipMessageDroppedTasks"), new Gauge<Long>(){

            public Long getValue() {
                return messagingPool.getDroppedMessages(OutboundConnectionIdentifier.ConnectionType.GOSSIP);
            }
        });
        this.timeouts = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName("Timeouts"));
    }

    public void release() {
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("LargeMessagePendingTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("LargeMessageCompletedTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("LargeMessageDroppedTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("SmallMessagePendingTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("SmallMessageCompletedTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("SmallMessageDroppedTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("GossipMessagePendingTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("GossipMessageCompletedTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("GossipMessageDroppedTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("Timeouts"));
    }
}

