/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Gauge;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.cassandra.metrics.BaseCompositeCounter;
import org.apache.cassandra.metrics.BaseCompositeMeter;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.Counter;
import org.apache.cassandra.metrics.Histogram;
import org.apache.cassandra.metrics.Meter;
import org.apache.cassandra.metrics.MetricNameFactory;

abstract class DbMetrics {
    private final MetricNameFactory factory;
    private final Set<CassandraMetricsRegistry.MetricName> metricNames;

    DbMetrics(MetricNameFactory factory) {
        this.factory = factory;
        this.metricNames = Sets.newConcurrentHashSet();
    }

    DbMetrics(DbMetrics other) {
        this.factory = other.factory;
        this.metricNames = other.metricNames;
    }

    private CassandraMetricsRegistry.MetricName createMetricName(String name) {
        CassandraMetricsRegistry.MetricName metricName = this.factory.createMetricName(name);
        this.metricNames.add(metricName);
        return metricName;
    }

    protected final Counter registerCounter(String name) {
        return this.registerCounter(name, false);
    }

    protected final Counter registerCounter(String name, boolean composite) {
        return CassandraMetricsRegistry.Metrics.counter(this.createMetricName(name), composite);
    }

    protected final <T> Gauge<T> registerGauge(String name, Gauge<T> gauge) {
        return CassandraMetricsRegistry.Metrics.register(this.createMetricName(name), gauge);
    }

    protected final Meter registerMeter(String name, boolean composite) {
        return CassandraMetricsRegistry.Metrics.meter(this.createMetricName(name), composite);
    }

    protected final Meter registerMeter(String name) {
        return this.registerMeter(name, false);
    }

    protected final Histogram registerHistogram(String name, boolean considerZeroes) {
        return CassandraMetricsRegistry.Metrics.histogram(this.createMetricName(name), considerZeroes);
    }

    protected final Counter registerCompositeCounter(String name, final Supplier<Stream<Counter>> supplier) {
        return CassandraMetricsRegistry.Metrics.register(this.createMetricName(name), new BaseCompositeCounter(){

            @Override
            protected Stream<Counter> countersStream() {
                return (Stream)supplier.get();
            }
        });
    }

    protected final Meter registerCompositeMeter(String name, final Supplier<Stream<Meter>> supplier) {
        return CassandraMetricsRegistry.Metrics.register(this.createMetricName(name), new BaseCompositeMeter(){

            @Override
            protected Stream<Meter> metersStream() {
                return (Stream)supplier.get();
            }
        });
    }

    public void release() {
        for (CassandraMetricsRegistry.MetricName metricName : this.metricNames) {
            CassandraMetricsRegistry.Metrics.remove(metricName);
        }
        this.metricNames.clear();
    }
}

