/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.util.concurrent.MoreExecutors;
import java.net.InetAddress;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.cassandra.concurrent.TPCUtils;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.Counter;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.utils.UUIDGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HintedHandoffMetrics {
    private static final Logger logger = LoggerFactory.getLogger(HintedHandoffMetrics.class);
    private static final MetricNameFactory factory = new DefaultNameFactory("HintedHandOffManager");
    private final LoadingCache<InetAddress, DifferencingCounter> notStored = Caffeine.newBuilder().executor(MoreExecutors.directExecutor()).build(DifferencingCounter::new);
    private final LoadingCache<InetAddress, Counter> createdHintCounts = Caffeine.newBuilder().executor(MoreExecutors.directExecutor()).build(address -> CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("Hints_created-" + address.getHostAddress().replace(':', '.'))));

    public void incrCreatedHints(InetAddress address) {
        ((Counter)this.createdHintCounts.get((Object)address)).inc();
    }

    public void incrPastWindow(InetAddress address) {
        ((DifferencingCounter)this.notStored.get((Object)address)).mark();
    }

    public void log() {
        for (Map.Entry entry : this.notStored.asMap().entrySet()) {
            long difference = ((DifferencingCounter)entry.getValue()).difference();
            if (difference == 0L) continue;
            logger.warn("{} has {} dropped hints, because node is down past configured hint window.", entry.getKey(), (Object)difference);
            TPCUtils.blockingAwait((CompletableFuture)SystemKeyspace.updateHintsDropped((InetAddress)((InetAddress)entry.getKey()), (UUID)UUIDGen.getTimeUUID(), (int)((int)difference)));
        }
    }

    public static class DifferencingCounter {
        private final Counter meter;
        private long reported = 0L;

        public DifferencingCounter(InetAddress address) {
            this.meter = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("Hints_not_stored-" + address.getHostAddress().replace(':', '.')));
        }

        public long difference() {
            long current = this.meter.getCount();
            long difference = current - this.reported;
            this.reported = current;
            return difference;
        }

        public long count() {
            return this.meter.getCount();
        }

        public void mark() {
            this.meter.inc();
        }
    }
}

