/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Snapshot;
import com.google.common.annotations.VisibleForTesting;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.metrics.ApproximateClock;
import org.apache.cassandra.metrics.Composable;
import org.apache.cassandra.metrics.CompositeHistogram;
import org.apache.cassandra.metrics.DecayingEstimatedHistogram;

public abstract class Histogram
extends com.codahale.metrics.Histogram
implements Composable<Histogram> {
    public static boolean DEFAULT_ZERO_CONSIDERATION = false;
    public static long DEFAULT_MAX_TRACKABLE_VALUE = 0x900000000000L;

    protected Histogram() {
        super(null);
    }

    public abstract void update(long var1);

    public abstract long getCount();

    public abstract Snapshot getSnapshot();

    public abstract void clear();

    @VisibleForTesting
    public abstract void aggregate();

    public abstract boolean considerZeroes();

    public abstract long maxTrackableValue();

    public abstract long[] getOffsets();

    public static Histogram make(boolean isComposite) {
        return Histogram.make(DEFAULT_ZERO_CONSIDERATION, isComposite);
    }

    public static Histogram make(boolean considerZeroes, boolean isComposite) {
        return Histogram.make(considerZeroes, DEFAULT_MAX_TRACKABLE_VALUE, isComposite);
    }

    public static Histogram make(boolean considerZeroes, long maxTrackableValue, boolean isComposite) {
        return Histogram.make(considerZeroes, maxTrackableValue, DatabaseDescriptor.getMetricsHistogramUpdateTimeMillis(), isComposite);
    }

    public static Histogram make(boolean considerZeroes, int updateIntervalMillis, boolean isComposite) {
        return Histogram.make(considerZeroes, DEFAULT_MAX_TRACKABLE_VALUE, updateIntervalMillis, isComposite);
    }

    public static Histogram make(boolean considerZeroes, long maxTrackableValue, int updateIntervalMillis, boolean isComposite) {
        return isComposite ? new CompositeHistogram(DecayingEstimatedHistogram.makeCompositeReservoir(considerZeroes, maxTrackableValue, updateIntervalMillis, ApproximateClock.defaultClock())) : new DecayingEstimatedHistogram(considerZeroes, maxTrackableValue, updateIntervalMillis, ApproximateClock.defaultClock());
    }

    static interface Reservoir {
        public boolean considerZeroes();

        public long maxTrackableValue();

        public long getCount();

        public Snapshot getSnapshot();

        public void add(Histogram var1);

        public long[] getOffsets();
    }
}

