/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import java.net.InetAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.metrics.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingMetrics {
    private static Logger logger = LoggerFactory.getLogger(MessagingMetrics.class);
    private static final MetricNameFactory factory = new DefaultNameFactory("Messaging");
    public final Timer crossNodeLatency = CassandraMetricsRegistry.Metrics.timer(factory.createMetricName("CrossNodeLatency"));
    public final ConcurrentHashMap<String, Timer> dcLatency = new ConcurrentHashMap();
    public final ConcurrentHashMap<String, Timer> queueWaitLatency = new ConcurrentHashMap();

    public void addTimeTaken(InetAddress from, long timeTaken) {
        String dc = DatabaseDescriptor.getEndpointSnitch().getDatacenter(from);
        Timer timer = this.dcLatency.get(dc);
        if (timer == null) {
            timer = this.dcLatency.computeIfAbsent(dc, k -> CassandraMetricsRegistry.Metrics.timer(factory.createMetricName(dc + "-Latency")));
        }
        timer.update(timeTaken, TimeUnit.MILLISECONDS);
        this.crossNodeLatency.update(timeTaken, TimeUnit.MILLISECONDS);
    }

    public void addQueueWaitTime(String messageType, long timeTakenNanos) {
        if (timeTakenNanos < 0L) {
            return;
        }
        Timer timer = this.queueWaitLatency.get(messageType);
        if (timer == null) {
            timer = this.queueWaitLatency.computeIfAbsent(messageType, k -> CassandraMetricsRegistry.Metrics.timer(factory.createMetricName(messageType + "-WaitLatency")));
        }
        timer.update(timeTakenNanos, TimeUnit.NANOSECONDS);
    }
}

