/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Gauge;
import io.netty.util.internal.PlatformDependent;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.Meter;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.utils.UnsafeMemoryAccess;
import org.apache.cassandra.utils.obs.OffHeapBitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeMemoryMetrics {
    private static final Logger logger = LoggerFactory.getLogger(NativeMemoryMetrics.class);
    public static NativeMemoryMetrics instance = new NativeMemoryMetrics();
    public static long smallBufferThreshold = 4 * UnsafeMemoryAccess.pageSize();
    private final MetricNameFactory factory = new DefaultNameFactory("NativeMemory");
    private final BufferPoolMXBean directBufferPool = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class).stream().filter(bpMBean -> bpMBean.getName().equals("direct")).findFirst().orElse(null);
    public final Meter totalAlignedAllocations;
    public final Meter smallAlignedAllocations;
    public final Gauge<Long> rawNativeMemory;
    public final Gauge<Long> bloomFilterMemory;
    public final Gauge<Long> usedNioDirectMemory;
    public final Gauge<Long> totalNioDirectMemory;
    public final Gauge<Long> networkDirectMemory;
    public final Gauge<Long> nioDirectBufferCount;
    public final Gauge<Long> totalMemory;

    public NativeMemoryMetrics() {
        if (this.directBufferPool == null) {
            logger.error("Direct memory buffer pool MBean not present, native memory metrics will be missing for nio buffers");
        }
        this.totalAlignedAllocations = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName("TotalAlignedAllocations"));
        this.smallAlignedAllocations = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName("SmallAlignedAllocations"));
        this.rawNativeMemory = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("RawNativeMemory"), this::rawNativeMemory);
        this.bloomFilterMemory = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("BloomFilterMemory"), this::bloomFilterMemory);
        this.usedNioDirectMemory = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("UsedNioDirectMemory"), this::usedNioDirectMemory);
        this.totalNioDirectMemory = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("TotalNioDirectMemory"), this::totalNioDirectMemory);
        this.networkDirectMemory = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("NetworkDirectMemory"), this::networkDirectMemory);
        this.nioDirectBufferCount = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("NioDirectBufferCount"), this::nioDirectBufferCount);
        this.totalMemory = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("TotalMemory"), this::totalMemory);
    }

    public long rawNativeMemory() {
        return UnsafeMemoryAccess.allocated();
    }

    public long bloomFilterMemory() {
        return OffHeapBitSet.memoryAllocated();
    }

    public long usedNioDirectMemory() {
        return this.directBufferPool == null ? 0L : this.directBufferPool.getMemoryUsed();
    }

    public long totalNioDirectMemory() {
        return this.directBufferPool == null ? 0L : this.directBufferPool.getTotalCapacity();
    }

    public long nioDirectBufferCount() {
        return this.directBufferPool == null ? 0L : this.directBufferPool.getCount();
    }

    public long totalMemory() {
        return this.rawNativeMemory() + this.totalNioDirectMemory() + (this.usingNioMemoryForNetwork() ? 0L : this.networkDirectMemory());
    }

    public long networkDirectMemory() {
        return PlatformDependent.usedDirectMemory();
    }

    public boolean usingNioMemoryForNetwork() {
        return !PlatformDependent.useDirectBufferNoCleaner();
    }
}

