/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.datastax.bdp.db.nodesync.ValidationOutcome;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.Counter;
import org.apache.cassandra.metrics.Histogram;
import org.apache.cassandra.metrics.Meter;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.cassandra.utils.SetsFactory;
import org.apache.cassandra.utils.time.ApolloTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeSyncMetrics {
    private static final Logger logger = LoggerFactory.getLogger(NodeSyncMetrics.class);
    public final Meter dataValidated;
    public final Meter dataRepaired;
    private final Meter objectsValidated;
    private final Meter objectsRepaired;
    private final Meter repairDataSent;
    private final Meter repairObjectsSent;
    public final Counter processedPages;
    public final Counter fullInSyncPages;
    public final Counter fullRepairedPages;
    public final Counter partialInSyncPages;
    public final Counter partialRepairedPages;
    public final Counter uncompletedPages;
    public final Counter failedPages;
    public final Histogram incrementalValidationsCoveredAges;
    public final Counter nonIncrementalValidations;
    private final MetricNameFactory factory;
    private final String namePrefix;
    private final Set<CassandraMetricsRegistry.MetricName> metricsNames = SetsFactory.newSet();

    public NodeSyncMetrics(MetricNameFactory factory, String namePrefix) {
        this.factory = factory;
        this.namePrefix = namePrefix;
        this.dataValidated = CassandraMetricsRegistry.Metrics.meter(this.name("DataValidated"));
        this.dataRepaired = CassandraMetricsRegistry.Metrics.meter(this.name("DataRepaired"));
        this.repairDataSent = CassandraMetricsRegistry.Metrics.meter(this.name("RepairDataSent"));
        this.objectsValidated = CassandraMetricsRegistry.Metrics.meter(this.name("ObjectsValidated"));
        this.objectsRepaired = CassandraMetricsRegistry.Metrics.meter(this.name("ObjectsRepaired"));
        this.repairObjectsSent = CassandraMetricsRegistry.Metrics.meter(this.name("RepairObjectsSent"));
        this.processedPages = CassandraMetricsRegistry.Metrics.counter(this.name("ProcessedPages"));
        this.fullInSyncPages = CassandraMetricsRegistry.Metrics.counter(this.name("FullInSyncPages"));
        this.fullRepairedPages = CassandraMetricsRegistry.Metrics.counter(this.name("FullRepairedPages"));
        this.partialInSyncPages = CassandraMetricsRegistry.Metrics.counter(this.name("PartialInSyncPages"));
        this.partialRepairedPages = CassandraMetricsRegistry.Metrics.counter(this.name("PartialRepairedPages"));
        this.uncompletedPages = CassandraMetricsRegistry.Metrics.counter(this.name("UncompletedPages"));
        this.failedPages = CassandraMetricsRegistry.Metrics.counter(this.name("FailedPages"));
        this.incrementalValidationsCoveredAges = CassandraMetricsRegistry.Metrics.histogram(this.name("IncrementalValidationsCoveredAgesSeconds"), true);
        this.nonIncrementalValidations = CassandraMetricsRegistry.Metrics.counter(this.name("NonIncrementalValidations"));
    }

    public void incrementObjects(long validated, long repaired) {
        this.objectsValidated.mark(validated);
        this.objectsRepaired.mark(repaired);
    }

    public void incrementDataSizes(long validated, long repaired) {
        this.dataValidated.mark(validated);
        this.dataRepaired.mark(repaired);
    }

    public void incrementRepairSent(long dataSent, long objectsSent) {
        this.repairDataSent.mark(dataSent);
        this.repairObjectsSent.mark(objectsSent);
    }

    public void addPageOutcomes(ValidationOutcome outcome, long pageCount) {
        this.processedPages.inc(pageCount);
        switch (outcome) {
            case FULL_IN_SYNC: {
                this.fullInSyncPages.inc(pageCount);
                break;
            }
            case FULL_REPAIRED: {
                this.fullRepairedPages.inc(pageCount);
                break;
            }
            case PARTIAL_IN_SYNC: {
                this.partialInSyncPages.inc(pageCount);
                break;
            }
            case PARTIAL_REPAIRED: {
                this.partialRepairedPages.inc(pageCount);
                break;
            }
            case UNCOMPLETED: {
                this.uncompletedPages.inc(pageCount);
                break;
            }
            case FAILED: {
                this.failedPages.inc(pageCount);
            }
        }
    }

    public void addIncrementalValidationMetric(long incrementalTimestamp, long minTimestampSeen) {
        if (incrementalTimestamp == Long.MAX_VALUE) {
            this.incrementalValidationsCoveredAges.update(0);
        } else if (minTimestampSeen < 0L) {
            NoSpamLogger.log((Logger)logger, (NoSpamLogger.Level)NoSpamLogger.Level.WARN, (long)10L, (TimeUnit)TimeUnit.MINUTES, (String)"Got a negative timestamp ({}) when updating metrics for an incremental validation; this may happen if negative custom user provided timestamps were provided in some inserts. Please note that such negative user provided timestamp are inefficient for Incremental NodeSync. In particular, the 'incremental validation covered ages' metrics will be meaningless", (Object[])new Object[]{minTimestampSeen});
            this.incrementalValidationsCoveredAges.update(Long.MAX_VALUE);
        } else {
            long ageSeconds = TimeUnit.MICROSECONDS.toSeconds(ApolloTime.systemClockMicros() - minTimestampSeen);
            this.incrementalValidationsCoveredAges.update(Math.max(1L, ageSeconds));
        }
        if (incrementalTimestamp < 0L) {
            this.nonIncrementalValidations.inc();
        }
    }

    private CassandraMetricsRegistry.MetricName name(String name) {
        CassandraMetricsRegistry.MetricName metricName = this.factory.createMetricName(this.namePrefix + name);
        this.metricsNames.add(metricName);
        return metricName;
    }

    public void release() {
        for (CassandraMetricsRegistry.MetricName name : this.metricsNames) {
            CassandraMetricsRegistry.Metrics.remove(name);
        }
    }
}

