/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import java.net.InetAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.net.Verbs;

public final class ReadCoordinationMetrics {
    private static final MetricNameFactory factory = new DefaultNameFactory("ReadCoordination");
    public static final Counter nonreplicaRequests = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("LocalNodeNonreplicaRequests"));
    public static final Counter preferredOtherReplicas = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("PreferredOtherReplicas"));
    private static final ConcurrentMap<InetAddress, Histogram> replicaLatencies = new ConcurrentHashMap<InetAddress, Histogram>();

    public static void updateReplicaLatency(Verb<?, ?> verb, InetAddress address, long latency) {
        if (!verb.group().equals(Verbs.READS)) {
            return;
        }
        if (latency == DatabaseDescriptor.getReadRpcTimeout()) {
            return;
        }
        Histogram histogram = (Histogram)replicaLatencies.get(address);
        if (null == histogram) {
            histogram = replicaLatencies.computeIfAbsent(address, ReadCoordinationMetrics::createHistogram);
        }
        histogram.update(latency);
    }

    private static Histogram createHistogram(InetAddress a) {
        return CassandraMetricsRegistry.Metrics.histogram(DefaultNameFactory.createMetricName("ReadCoordination", "ReplicaLatency", a.getHostAddress().replace(':', '.')), false);
    }
}

