/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Clock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.concurrent.TPC;
import org.apache.cassandra.metrics.Composable;
import org.apache.cassandra.metrics.Counter;
import org.apache.cassandra.metrics.EWMA;
import org.apache.cassandra.metrics.Meter;

public class SingleMeter
extends Meter {
    public static final long TICK_INTERVAL = TimeUnit.SECONDS.toNanos(5L);
    private final EWMA m1Rate = EWMA.oneMinuteEWMA(false);
    private final EWMA m5Rate = EWMA.fiveMinuteEWMA(false);
    private final EWMA m15Rate = EWMA.fifteenMinuteEWMA(false);
    private final Clock clock;
    private final boolean tickOnCurrentCore;
    private final AtomicLong lastCounted = new AtomicLong();
    private final Counter count;
    private final long startTime;
    private final AtomicLong lastTick;
    private final AtomicBoolean scheduled = new AtomicBoolean(false);

    public SingleMeter() {
        this(Clock.defaultClock(), false);
    }

    public SingleMeter(Clock clock, boolean tickOnCurrentCore) {
        this.clock = clock;
        this.tickOnCurrentCore = tickOnCurrentCore;
        this.count = Counter.make(false);
        this.startTime = this.clock.getTick();
        this.lastTick = new AtomicLong(this.startTime);
    }

    private void maybeScheduleTick() {
        if (this.tickOnCurrentCore) {
            this.tickIfNecessary();
            return;
        }
        if (this.scheduled.get()) {
            return;
        }
        if (this.scheduled.compareAndSet(false, true)) {
            this.schedule();
        }
    }

    private void schedule() {
        if (TPC.DEBUG_DONT_SCHEDULE_METRICS) {
            return;
        }
        TPC.bestTPCTimer().onTimeout(this::scheduledTick, TICK_INTERVAL, TimeUnit.NANOSECONDS);
    }

    @Override
    public void mark(long n) {
        this.maybeScheduleTick();
        this.count.inc(n);
    }

    private void scheduledTick() {
        this.scheduled.set(false);
        this.tickIfNecessary();
    }

    private void tickIfNecessary() {
        long newIntervalStartTick;
        long oldTick = this.lastTick.get();
        long newTick = this.clock.getTick();
        long age = newTick - oldTick;
        if (age > TICK_INTERVAL && this.lastTick.compareAndSet(oldTick, newIntervalStartTick = newTick - age % TICK_INTERVAL)) {
            long requiredTicks = age / TICK_INTERVAL;
            for (long i = 0L; i < requiredTicks; ++i) {
                long count = this.getUncounted();
                this.m1Rate.tick(count);
                this.m5Rate.tick(count);
                this.m15Rate.tick(count);
            }
        }
    }

    private long getUncounted() {
        long current = this.getCount();
        long previous = this.lastCounted.getAndSet(current);
        return current - previous;
    }

    @Override
    public long getCount() {
        return this.count.getCount();
    }

    @Override
    public double getFifteenMinuteRate() {
        this.tickIfNecessary();
        return this.m15Rate.getRate(TimeUnit.SECONDS);
    }

    @Override
    public double getFiveMinuteRate() {
        this.tickIfNecessary();
        return this.m5Rate.getRate(TimeUnit.SECONDS);
    }

    @Override
    public double getMeanRate() {
        return this.getMeanRate(this.getCount());
    }

    public double getMeanRate(long count) {
        if (count == 0L) {
            return 0.0;
        }
        double elapsed = this.clock.getTick() - this.startTime;
        return (double)count / elapsed * (double)TimeUnit.SECONDS.toNanos(1L);
    }

    @Override
    public double getOneMinuteRate() {
        this.tickIfNecessary();
        return this.m1Rate.getRate(TimeUnit.SECONDS);
    }

    @Override
    public Composable.Type getType() {
        return Composable.Type.SINGLE;
    }
}

