/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import java.net.InetAddress;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.Counter;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.jctools.maps.NonBlockingHashMap;

public class StreamingMetrics {
    public static final String TYPE_NAME = "Streaming";
    private static final ConcurrentMap<InetAddress, StreamingMetrics> instances = new NonBlockingHashMap();
    public static final Counter activeStreamsOutbound = CassandraMetricsRegistry.Metrics.counter(DefaultNameFactory.createMetricName("Streaming", "ActiveOutboundStreams", null));
    public static final Counter totalIncomingBytes = CassandraMetricsRegistry.Metrics.counter(DefaultNameFactory.createMetricName("Streaming", "TotalIncomingBytes", null));
    public static final Counter totalOutgoingBytes = CassandraMetricsRegistry.Metrics.counter(DefaultNameFactory.createMetricName("Streaming", "TotalOutgoingBytes", null));
    public final Counter incomingBytes;
    public final Counter outgoingBytes;

    public static StreamingMetrics get(InetAddress ip) {
        StreamingMetrics metrics = (StreamingMetrics)instances.get(ip);
        if (metrics == null) {
            metrics = new StreamingMetrics(ip);
            instances.put(ip, metrics);
        }
        return metrics;
    }

    public StreamingMetrics(InetAddress peer) {
        DefaultNameFactory factory = new DefaultNameFactory(TYPE_NAME, peer.getHostAddress().replace(':', '.'));
        this.incomingBytes = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("IncomingBytes"));
        this.outgoingBytes = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("OutgoingBytes"));
    }
}

