/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Gauge;
import org.apache.cassandra.concurrent.TPCTaskLifecycleMetrics;
import org.apache.cassandra.concurrent.TPCTaskType;
import org.apache.cassandra.metrics.AbstractThreadPoolMetrics;

public class TPCTaskMetricsReporter
extends AbstractThreadPoolMetrics {
    public final Gauge<Integer> activeTasks = this.registerIntMetric("ActiveTasks", (Gauge<Integer>)((Gauge)() -> (int)metrics.activeTaskCount(taskType)));
    public final Gauge<Long> sharedTasks = this.registerLongMetric("SharedTasks", (Gauge<Long>)((Gauge)() -> metrics.sharedTaskCount(taskType)));
    public final Gauge<Long> stolenTasks = this.registerLongMetric("StolenTasks", (Gauge<Long>)((Gauge)() -> metrics.stolenTaskCount(taskType)));
    public final Gauge<Long> completedTasks = this.registerLongMetric("CompletedTasks", (Gauge<Long>)((Gauge)() -> metrics.completedTaskCount(taskType)));
    public final Gauge<Integer> pendingTasks;
    public final Gauge<Long> blockedTasks;

    public TPCTaskMetricsReporter(TPCTaskLifecycleMetrics metrics, TPCTaskType taskType, String path, String poolPrefix) {
        super(path, poolPrefix + "/" + taskType.loggedEventName);
        if (taskType.pendable()) {
            this.pendingTasks = this.registerIntMetric("PendingTasks", (Gauge<Integer>)((Gauge)() -> (int)metrics.pendingTaskCount(taskType)));
            this.blockedTasks = this.registerLongMetric("TotalBlockedTasksGauge", (Gauge<Long>)((Gauge)() -> metrics.blockedTaskCount(taskType)));
        } else {
            this.pendingTasks = null;
            this.blockedTasks = null;
        }
    }
}

