/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Gauge;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToLongFunction;
import org.apache.cassandra.concurrent.TPCEventType;
import org.apache.cassandra.concurrent.TPCMetrics;
import org.apache.cassandra.concurrent.TPCTaskLifecycleMetrics;
import org.apache.cassandra.concurrent.TPCTaskType;
import org.apache.cassandra.metrics.AbstractThreadPoolMetrics;
import org.apache.cassandra.metrics.Meter;
import org.apache.cassandra.metrics.TPCTaskMetricsReporter;

public class TPCThreadMetricsReporter
extends AbstractThreadPoolMetrics {
    public final Gauge<Integer> activeTasks;
    public final Gauge<Long> sharedTasks;
    public final Gauge<Long> stolenTasks;
    public final Gauge<Long> completedTasks;
    public final Gauge<Integer> pendingTasks;
    public final Gauge<Long> blockedTasks;
    public final Gauge<Long> bpDelayedTasks;
    public final Gauge<Long> bpCountedTasks;
    public final TPCMetrics metrics;
    private final List<TPCTaskMetricsReporter> tracked = new ArrayList<TPCTaskMetricsReporter>();

    public TPCThreadMetricsReporter(TPCMetrics metrics, String path, String poolPrefix) {
        super(path, poolPrefix);
        this.metrics = metrics;
        this.activeTasks = this.registerIntMetric("ActiveTasks", (Gauge<Integer>)((Gauge)this::getActiveTotal));
        this.sharedTasks = this.registerLongMetric("SharedTasks", (Gauge<Long>)((Gauge)this::getSharedTotal));
        this.stolenTasks = this.registerLongMetric("StolenTasks", (Gauge<Long>)((Gauge)this::getStolenTotal));
        this.completedTasks = this.registerLongMetric("CompletedTasks", (Gauge<Long>)((Gauge)this::getCompletedTotal));
        this.pendingTasks = this.registerIntMetric("PendingTasks", (Gauge<Integer>)((Gauge)this::getPendingTotal));
        this.blockedTasks = this.registerLongMetric("TotalBlockedTasksGauge", (Gauge<Long>)((Gauge)this::getBlockedTotal));
        this.bpCountedTasks = this.registerLongMetric("TotalBackpressureCountedTasksGauge", (Gauge<Long>)((Gauge)this::getBackpressureCountedTotal));
        this.bpDelayedTasks = this.registerLongMetric("TotalBackpressureDelayedTasksGauge", (Gauge<Long>)((Gauge)this::getBackpressureDelayedTotal));
        for (TPCTaskType tPCTaskType : TPCTaskType.values()) {
            this.tracked.add(new TPCTaskMetricsReporter((TPCTaskLifecycleMetrics)metrics, tPCTaskType, path, poolPrefix));
        }
        for (TPCTaskType tPCTaskType : TPCEventType.values()) {
            Meter eventMeter = metrics.getEventMeter((TPCEventType)tPCTaskType);
            this.registerMeterMetric(tPCTaskType.loggedEventName(), eventMeter);
        }
    }

    @Override
    public synchronized void release() {
        super.release();
        for (TPCTaskMetricsReporter t : this.tracked) {
            t.release();
        }
        this.tracked.clear();
    }

    private int getActiveTotal() {
        return (int)this.totalForAllTypes(s -> this.metrics.activeTaskCount(s));
    }

    private long getSharedTotal() {
        return this.totalForAllTypes(s -> this.metrics.sharedTaskCount(s));
    }

    private long getStolenTotal() {
        return this.totalForAllTypes(s -> this.metrics.stolenTaskCount(s));
    }

    private long getCompletedTotal() {
        return this.totalForAllTypes(s -> this.metrics.completedTaskCount(s));
    }

    private int getPendingTotal() {
        return (int)this.totalForAllTypes(s -> this.metrics.pendingTaskCount(s));
    }

    private long getBlockedTotal() {
        return this.totalForAllTypes(s -> this.metrics.blockedTaskCount(s));
    }

    private long getBackpressureDelayedTotal() {
        return this.totalForAllTypes(s -> this.metrics.backpressureDelayedTaskCount(s));
    }

    private long totalForAllTypes(ToLongFunction<TPCTaskType> counter) {
        long blocked = 0L;
        for (TPCTaskType s : TPCTaskType.values()) {
            if (!s.includedInTotals()) continue;
            blocked += counter.applyAsLong(s);
        }
        return blocked;
    }

    private long getBackpressureCountedTotal() {
        return this.metrics.backpressureCountedTaskCount();
    }
}

