/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.JmxReporter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.TPCEventType;
import org.apache.cassandra.metrics.AbstractThreadPoolMetrics;
import org.apache.cassandra.metrics.Counter;

public class ThreadPoolExecutorMetrics
extends AbstractThreadPoolMetrics {
    public final Gauge<Integer> activeTasks = this.registerIntMetric("ActiveTasks", (Gauge<Integer>)((Gauge)executor::getActiveCount));
    public final Counter totalBlocked;
    public final Counter currentBlocked;
    public final Gauge<Long> completedTasks = this.registerLongMetric("CompletedTasks", (Gauge<Long>)((Gauge)executor::getCompletedTaskCount));
    public final Gauge<Long> pendingTasks = this.registerLongMetric("PendingTasks", (Gauge<Long>)((Gauge)() -> executor.getTaskCount() - (long)executor.getActiveCount() - executor.getCompletedTaskCount()));
    public final Gauge<Integer> maxPoolSize = this.registerIntMetric("MaxPoolSize", (Gauge<Integer>)((Gauge)executor::getMaximumPoolSize));

    public ThreadPoolExecutorMetrics(ThreadPoolExecutor executor, String path, String poolName) {
        super(path, poolName);
        this.totalBlocked = this.registeredCounter("TotalBlockedTasks");
        this.currentBlocked = this.registeredCounter("CurrentlyBlockedTasks");
    }

    public static Object getJmxMetric(MBeanServerConnection mbeanServerConn, String jmxPath, String poolName, String metricName) {
        String name = String.format("org.apache.cassandra.metrics:type=ThreadPools,path=%s,scope=%s,name=%s", jmxPath, poolName, metricName);
        try {
            ObjectName oName = new ObjectName(name);
            if (!mbeanServerConn.isRegistered(oName)) {
                oName = new ObjectName(name + "Gauge");
                metricName = metricName + "Gauge";
                if (!mbeanServerConn.isRegistered(oName)) {
                    return "N/A";
                }
            }
            switch (metricName) {
                case "ActiveTasks": 
                case "PendingTasks": 
                case "SharedTasks": 
                case "StolenTasks": 
                case "CompletedTasks": 
                case "TotalBackpressureCountedTasksGauge": 
                case "TotalBackpressureDelayedTasksGauge": 
                case "TotalBlockedTasksGauge": {
                    return JMX.newMBeanProxy(mbeanServerConn, oName, JmxReporter.JmxGaugeMBean.class).getValue();
                }
                case "TotalBlockedTasks": 
                case "CurrentlyBlockedTasks": {
                    return JMX.newMBeanProxy(mbeanServerConn, oName, JmxReporter.JmxCounterMBean.class).getCount();
                }
            }
            for (TPCEventType event : TPCEventType.values()) {
                if (!event.loggedEventName().equals(metricName)) continue;
                return JMX.newMBeanProxy(mbeanServerConn, oName, JmxReporter.JmxMeterMBean.class);
            }
            throw new AssertionError((Object)("Unknown metric name " + metricName));
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading: " + name, e);
        }
    }

    public static Multimap<String, String> getJmxThreadPools(MBeanServerConnection mbeanServerConn) {
        try {
            HashMultimap threadPools = HashMultimap.create();
            Set<ObjectName> threadPoolObjectNames = mbeanServerConn.queryNames(new ObjectName("org.apache.cassandra.metrics:type=ThreadPools,*"), null);
            for (ObjectName oName : threadPoolObjectNames) {
                threadPools.put((Object)oName.getKeyProperty("path"), (Object)oName.getKeyProperty("scope"));
            }
            return threadPools;
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Bad query to JMX server: ", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error getting threadpool names from JMX", e);
        }
    }
}

