/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Sampling;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.metrics.Composable;
import org.apache.cassandra.metrics.CompositeMeter;
import org.apache.cassandra.metrics.Histogram;
import org.apache.cassandra.metrics.Meter;
import org.apache.cassandra.metrics.SingleMeter;

public class Timer
extends com.codahale.metrics.Timer
implements Metered,
Sampling,
Composable<Timer> {
    private final Meter meter;
    private final Histogram histogram;
    private final Composable.Type composableType;
    private final Clock clock;

    public Timer() {
        this(false);
    }

    public Timer(boolean isComposite) {
        this(Histogram.make(isComposite), Clock.defaultClock(), isComposite);
    }

    public Timer(Histogram histogram, Clock clock, boolean isComposite) {
        this.meter = isComposite ? new CompositeMeter() : new SingleMeter(clock, false);
        this.histogram = histogram;
        this.composableType = isComposite ? Composable.Type.COMPOSITE : Composable.Type.SINGLE;
        this.clock = clock;
    }

    public void update(long duration, TimeUnit unit) {
        this.update(unit.toNanos(duration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T time(Callable<T> event) throws Exception {
        if (this.composableType == Composable.Type.COMPOSITE) {
            throw new UnsupportedOperationException("Composite timer cannot time an event");
        }
        long startTime = this.clock.getTick();
        try {
            T t = event.call();
            return t;
        }
        finally {
            this.update(this.clock.getTick() - startTime);
        }
    }

    public Timer.Context time() {
        throw new UnsupportedOperationException("Use Timer.timer() instead.");
    }

    public Context timer() {
        if (this.composableType == Composable.Type.COMPOSITE) {
            throw new UnsupportedOperationException("Composite timer cannot time an event");
        }
        return new Context(this, this.clock);
    }

    public long getCount() {
        return this.histogram.getCount();
    }

    public double getFifteenMinuteRate() {
        return this.meter.getFifteenMinuteRate();
    }

    public double getFiveMinuteRate() {
        return this.meter.getFiveMinuteRate();
    }

    public double getMeanRate() {
        return this.meter.getMeanRate();
    }

    public double getOneMinuteRate() {
        return this.meter.getOneMinuteRate();
    }

    public Snapshot getSnapshot() {
        return this.histogram.getSnapshot();
    }

    private void update(long duration) {
        if (this.composableType == Composable.Type.COMPOSITE) {
            throw new UnsupportedOperationException("Composite timer cannot be updated");
        }
        if (duration >= 0L) {
            this.histogram.update(duration);
            this.meter.mark();
        }
    }

    @Override
    public Composable.Type getType() {
        return this.composableType;
    }

    @Override
    public void compose(Timer metric) {
        if (this.composableType != Composable.Type.COMPOSITE) {
            throw new UnsupportedOperationException("Non composite timer cannot be composed with another timer");
        }
        this.meter.compose((Metric)metric.meter);
        this.histogram.compose((Metric)metric.histogram);
    }

    @VisibleForTesting
    public Histogram getHistogram() {
        return this.histogram;
    }

    public String toString() {
        Snapshot snapshot = this.histogram.getSnapshot();
        return String.format("min: %d, avg: %.2f, max: %d, [p50: %.2f, p75: %.2f, p95: %.2f, p99: %.2f]", snapshot.getMin(), snapshot.getMean(), snapshot.getMax(), snapshot.getMedian(), snapshot.get75thPercentile(), snapshot.get95thPercentile(), snapshot.get99thPercentile());
    }

    public static class Context
    implements Closeable {
        private final Timer timer;
        private final Clock clock;
        private final long startTime;

        private Context(Timer timer, Clock clock) {
            this.timer = timer;
            this.clock = clock;
            this.startTime = clock.getTick();
        }

        public long stop() {
            long elapsed = this.clock.getTick() - this.startTime;
            this.timer.update(elapsed, TimeUnit.NANOSECONDS);
            return elapsed;
        }

        @Override
        public void close() {
            this.stop();
        }
    }
}

