/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config.typesafe;

import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.internal.core.config.typesafe.TypesafeDriverExecutionProfile;
import com.datastax.oss.driver.internal.core.util.Loggers;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigOriginFactory;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import com.typesafe.config.ConfigValueType;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class TypesafeDriverConfig
implements DriverConfig {
    private static final Logger LOG = LoggerFactory.getLogger(TypesafeDriverConfig.class);
    private static final ConfigOrigin DEFAULT_OVERRIDES_ORIGIN = ConfigOriginFactory.newSimple((String)"default was overridden programmatically");
    private final ImmutableMap<String, TypesafeDriverExecutionProfile.Base> profiles;
    private volatile Config lastLoadedConfig;
    private final Map<DriverOption, Object> defaultOverrides = new ConcurrentHashMap<DriverOption, Object>();

    public TypesafeDriverConfig(Config config) {
        this.lastLoadedConfig = config;
        Map<String, Config> profileConfigs = this.extractProfiles(config);
        ImmutableMap.Builder<String, TypesafeDriverExecutionProfile.Base> builder = ImmutableMap.builder();
        for (Map.Entry<String, Config> entry : profileConfigs.entrySet()) {
            builder.put(entry.getKey(), new TypesafeDriverExecutionProfile.Base(entry.getKey(), entry.getValue()));
        }
        this.profiles = builder.build();
    }

    public boolean reload(Config config) {
        if ((config = this.applyDefaultOverrides(config)).equals(this.lastLoadedConfig)) {
            return false;
        }
        this.lastLoadedConfig = config;
        try {
            Map<String, Config> profileConfigs = this.extractProfiles(config);
            for (Map.Entry<String, Config> entry : profileConfigs.entrySet()) {
                String profileName = entry.getKey();
                TypesafeDriverExecutionProfile.Base profile = this.profiles.get(profileName);
                if (profile == null) {
                    LOG.warn("Unknown profile '{}' while reloading configuration. Adding profiles at runtime is not supported.", (Object)profileName);
                    continue;
                }
                profile.refresh(entry.getValue());
            }
            return true;
        }
        catch (Throwable t) {
            Loggers.warnWithException(LOG, "Error reloading configuration, keeping previous one", t);
            return false;
        }
    }

    private Map<String, Config> extractProfiles(Config sourceConfig) {
        ImmutableMap.Builder<String, Config> result = ImmutableMap.builder();
        Config defaultProfileConfig = sourceConfig.withoutPath("profiles");
        result.put("default", defaultProfileConfig);
        ConfigObject rootObject = sourceConfig.root();
        if (rootObject.containsKey((Object)"profiles") && rootObject.get((Object)"profiles").valueType() == ConfigValueType.OBJECT) {
            ConfigObject profilesObject = (ConfigObject)rootObject.get((Object)"profiles");
            for (String profileName : profilesObject.keySet()) {
                if (profileName.equals("default")) {
                    throw new IllegalArgumentException(String.format("Can't have %s as a profile name because it's used internally. Pick another name.", profileName));
                }
                ConfigValue profileObject = profilesObject.get((Object)profileName);
                if (profileObject.valueType() != ConfigValueType.OBJECT) continue;
                Config profileConfig = ((ConfigObject)profileObject).toConfig();
                result.put(profileName, profileConfig.withFallback((ConfigMergeable)defaultProfileConfig));
            }
        }
        return result.build();
    }

    @Override
    @NonNull
    public DriverExecutionProfile getProfile(@NonNull String profileName) {
        Preconditions.checkArgument(this.profiles.containsKey(profileName), "Unknown profile '%s'. Check your configuration.", (Object)profileName);
        return this.profiles.get(profileName);
    }

    @Override
    @NonNull
    public Map<String, ? extends DriverExecutionProfile> getProfiles() {
        return this.profiles;
    }

    public void overrideDefaults(@NonNull Map<DriverOption, Object> overrides) {
        this.defaultOverrides.putAll(overrides);
        this.reload(this.lastLoadedConfig);
    }

    private Config applyDefaultOverrides(Config source) {
        Config result = source;
        for (Map.Entry<DriverOption, Object> entry : this.defaultOverrides.entrySet()) {
            String path = entry.getKey().getPath();
            Object value = entry.getValue();
            if (TypesafeDriverConfig.isDefault(source, path)) {
                LOG.debug("Replacing default value for {} by {}", (Object)path, value);
                result = result.withValue(path, ConfigValueFactory.fromAnyRef((Object)value).withOrigin(DEFAULT_OVERRIDES_ORIGIN));
                continue;
            }
            LOG.debug("Ignoring default override for {} because the user has overridden the value", (Object)path);
        }
        return result;
    }

    private static boolean isDefault(Config config, String path) {
        if (!config.hasPath(path)) {
            return false;
        }
        ConfigOrigin origin = config.getValue(path).origin();
        if (origin.equals(DEFAULT_OVERRIDES_ORIGIN)) {
            return true;
        }
        URL url = origin.url();
        return url != null && url.toString().endsWith("reference.conf");
    }
}

