/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util.collection;

import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class QueryPlan
extends AbstractCollection<Node>
implements Queue<Node> {
    private final Object[] nodes;
    private final AtomicInteger nextIndex = new AtomicInteger();

    public QueryPlan(Object ... nodes) {
        this.nodes = nodes;
    }

    @Override
    @Nullable
    public Node poll() {
        int i = this.nextIndex.getAndIncrement();
        return i >= this.nodes.length ? null : (Node)this.nodes[i];
    }

    @Override
    @NonNull
    public Iterator<Node> iterator() {
        int i = this.nextIndex.get();
        if (i >= this.nodes.length) {
            return Collections.emptyList().iterator();
        }
        return Iterators.forArray((Node[])Arrays.copyOfRange(this.nodes, i, this.nodes.length, Node[].class));
    }

    @Override
    public int size() {
        return Math.max(this.nodes.length - this.nextIndex.get(), 0);
    }

    @Override
    public boolean offer(Node node) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Node remove() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Node element() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Node peek() {
        throw new UnsupportedOperationException("Not implemented");
    }
}

