/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db;

import io.stargate.db.ImmutablePagingPosition;
import io.stargate.db.ImmutableTableName;
import io.stargate.db.datastore.Row;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.QualifiedSchemaEntity;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
public interface PagingPosition {
    public static ImmutablePagingPosition.Builder builder() {
        return ImmutablePagingPosition.builder();
    }

    public static ImmutablePagingPosition.Builder ofCurrentRow(Row row) {
        ImmutablePagingPosition.Builder builder = ImmutablePagingPosition.builder();
        for (Column c : row.columns()) {
            ByteBuffer value = row.getBytesUnsafe(c.name());
            if (value == null) continue;
            builder.putCurrentRow(c, value);
        }
        return builder;
    }

    public Map<Column, ByteBuffer> currentRow();

    @Value.Lazy
    default public Map<String, ByteBuffer> currentRowValuesByColumnName() {
        return this.currentRow().entrySet().stream().collect(Collectors.toMap(e -> ((Column)e.getKey()).name(), Map.Entry::getValue));
    }

    @Value.Lazy
    default public TableName tableName() {
        Set tables = this.currentRow().keySet().stream().map(column -> ImmutableTableName.builder().keyspace(Objects.requireNonNull(column.keyspace())).name(Objects.requireNonNull(column.table())).build()).collect(Collectors.toSet());
        if (tables.isEmpty()) {
            throw new IllegalArgumentException("Missing table information in custom paging request.");
        }
        if (tables.size() > 1) {
            throw new IllegalArgumentException("Too many tables are referenced: " + tables);
        }
        return (TableName)tables.iterator().next();
    }

    default public ByteBuffer requiredValue(String columnName) {
        TableName table = this.tableName();
        ByteBuffer value = this.currentRowValuesByColumnName().get(columnName);
        if (value == null) {
            throw new IllegalArgumentException(String.format("Required value is not present in current row (table: %s, column: %s)", table.name(), columnName));
        }
        return value;
    }

    public ResumeMode resumeFrom();

    @Value.Default
    default public int remainingRows() {
        return Integer.MAX_VALUE;
    }

    @Value.Default
    default public int remainingRowsInPartition() {
        return Integer.MAX_VALUE;
    }

    @Value.Immutable
    public static interface TableName
    extends QualifiedSchemaEntity {
    }

    public static enum ResumeMode {
        NEXT_PARTITION,
        NEXT_ROW;

    }
}

