/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.datastore;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import io.stargate.db.datastore.Row;
import io.stargate.db.schema.Column;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ArrayListBackedRow
implements Row {
    private final List<Column> columns;
    private final List<ByteBuffer> values;
    private final ProtocolVersion protocolVersion;

    public ArrayListBackedRow(List<Column> columns, List<ByteBuffer> values, ProtocolVersion protocolVersion) {
        assert (columns.size() == values.size());
        this.columns = columns;
        this.values = values;
        this.protocolVersion = protocolVersion;
    }

    @Override
    public List<Column> columns() {
        return this.columns;
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.columns.size()) {
            throw new IndexOutOfBoundsException(String.format("Index %d is out of bounds: the row has %d columns", index, this.columns.size()));
        }
    }

    @Override
    public int firstIndexOf(@Nonnull String column) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!this.columns.get(i).name().equals(column)) continue;
            return i;
        }
        throw new IllegalArgumentException(String.format("Column '%s' is not defined in the Row's metadata.", column));
    }

    @Override
    @Nonnull
    public DataType getType(@Nonnull String column) {
        return this.getType(this.firstIndexOf(column));
    }

    @Override
    @Nonnull
    public DataType getType(int i) {
        this.checkIndex(i);
        return this.columns.get(i).type().codec().getCqlType();
    }

    @Override
    @Nullable
    public ByteBuffer getBytesUnsafe(int i) {
        this.checkIndex(i);
        return this.values.get(i);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    @Nonnull
    public CodecRegistry codecRegistry() {
        return Column.CODEC_REGISTRY;
    }

    @Override
    @Nonnull
    public ProtocolVersion protocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public String toString() {
        return this.columns().stream().map(c -> String.format("%s=%s", c.name(), this.getObject(c.name()))).collect(Collectors.joining(", ", "{", "}"));
    }
}

