/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.datastore;

import io.stargate.db.Parameters;
import io.stargate.db.datastore.ImmutableDataStoreOptions;
import java.util.Collections;
import java.util.Map;
import org.immutables.value.Value;

@Value.Immutable(singleton=true)
public abstract class DataStoreOptions {
    public static DataStoreOptions defaults() {
        return ImmutableDataStoreOptions.of();
    }

    public static DataStoreOptions defaultsWithAutoPreparedQueries() {
        return DataStoreOptions.builder().alwaysPrepareQueries(true).build();
    }

    public static ImmutableDataStoreOptions.Builder builder() {
        return ImmutableDataStoreOptions.builder();
    }

    @Value.Default
    public Parameters defaultParameters() {
        return Parameters.defaults();
    }

    @Value.Default
    public boolean alwaysPrepareQueries() {
        return false;
    }

    @Value.Default
    public Map<String, String> customProperties() {
        return Collections.emptyMap();
    }

    public String toString() {
        return String.format("{defaultParameters: %s, alwaysPrepareQueries: %b, customProperties: %s}", this.defaultParameters(), this.alwaysPrepareQueries(), this.customProperties());
    }
}

