/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.datastore;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.Parameters;
import io.stargate.db.datastore.DataStoreOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DataStoreOptions", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableDataStoreOptions
extends DataStoreOptions {
    private final Parameters defaultParameters;
    private final boolean alwaysPrepareQueries;
    private final Map<String, String> customProperties;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableDataStoreOptions INSTANCE = ImmutableDataStoreOptions.validate(new ImmutableDataStoreOptions());

    private ImmutableDataStoreOptions() {
        this.defaultParameters = this.initShim.defaultParameters();
        this.alwaysPrepareQueries = this.initShim.alwaysPrepareQueries();
        this.customProperties = this.initShim.customProperties();
        this.initShim = null;
    }

    private ImmutableDataStoreOptions(Builder builder) {
        if (builder.defaultParameters != null) {
            this.initShim.defaultParameters(builder.defaultParameters);
        }
        if (builder.alwaysPrepareQueriesIsSet()) {
            this.initShim.alwaysPrepareQueries(builder.alwaysPrepareQueries);
        }
        if (builder.customPropertiesIsSet()) {
            this.initShim.customProperties(ImmutableDataStoreOptions.createUnmodifiableMap(false, false, builder.customProperties));
        }
        this.defaultParameters = this.initShim.defaultParameters();
        this.alwaysPrepareQueries = this.initShim.alwaysPrepareQueries();
        this.customProperties = this.initShim.customProperties();
        this.initShim = null;
    }

    private ImmutableDataStoreOptions(Parameters defaultParameters, boolean alwaysPrepareQueries, Map<String, String> customProperties) {
        this.defaultParameters = defaultParameters;
        this.alwaysPrepareQueries = alwaysPrepareQueries;
        this.customProperties = customProperties;
        this.initShim = null;
    }

    @Override
    public Parameters defaultParameters() {
        InitShim shim = this.initShim;
        return shim != null ? shim.defaultParameters() : this.defaultParameters;
    }

    @Override
    public boolean alwaysPrepareQueries() {
        InitShim shim = this.initShim;
        return shim != null ? shim.alwaysPrepareQueries() : this.alwaysPrepareQueries;
    }

    @Override
    public Map<String, String> customProperties() {
        InitShim shim = this.initShim;
        return shim != null ? shim.customProperties() : this.customProperties;
    }

    public final ImmutableDataStoreOptions withDefaultParameters(Parameters value) {
        if (this.defaultParameters == value) {
            return this;
        }
        Parameters newValue = Objects.requireNonNull(value, "defaultParameters");
        return ImmutableDataStoreOptions.validate(new ImmutableDataStoreOptions(newValue, this.alwaysPrepareQueries, this.customProperties));
    }

    public final ImmutableDataStoreOptions withAlwaysPrepareQueries(boolean value) {
        if (this.alwaysPrepareQueries == value) {
            return this;
        }
        return ImmutableDataStoreOptions.validate(new ImmutableDataStoreOptions(this.defaultParameters, value, this.customProperties));
    }

    public final ImmutableDataStoreOptions withCustomProperties(Map<String, ? extends String> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableDataStoreOptions.createUnmodifiableMap(true, false, entries);
        return ImmutableDataStoreOptions.validate(new ImmutableDataStoreOptions(this.defaultParameters, this.alwaysPrepareQueries, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDataStoreOptions && this.equalTo((ImmutableDataStoreOptions)another);
    }

    private boolean equalTo(ImmutableDataStoreOptions another) {
        return this.defaultParameters.equals(another.defaultParameters) && this.alwaysPrepareQueries == another.alwaysPrepareQueries && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.defaultParameters.hashCode();
        h += (h << 5) + Boolean.hashCode(this.alwaysPrepareQueries);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public static ImmutableDataStoreOptions of() {
        return INSTANCE;
    }

    private static ImmutableDataStoreOptions validate(ImmutableDataStoreOptions instance) {
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static ImmutableDataStoreOptions copyOf(DataStoreOptions instance) {
        if (instance instanceof ImmutableDataStoreOptions) {
            return (ImmutableDataStoreOptions)instance;
        }
        return ImmutableDataStoreOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="DataStoreOptions", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_ALWAYS_PREPARE_QUERIES = 1L;
        private static final long OPT_BIT_CUSTOM_PROPERTIES = 2L;
        private long optBits;
        @Nullable
        private Parameters defaultParameters;
        private boolean alwaysPrepareQueries;
        private Map<String, String> customProperties = new LinkedHashMap<String, String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DataStoreOptions instance) {
            Objects.requireNonNull(instance, "instance");
            this.defaultParameters(instance.defaultParameters());
            this.alwaysPrepareQueries(instance.alwaysPrepareQueries());
            this.putAllCustomProperties(instance.customProperties());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultParameters(Parameters defaultParameters) {
            this.defaultParameters = Objects.requireNonNull(defaultParameters, "defaultParameters");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder alwaysPrepareQueries(boolean alwaysPrepareQueries) {
            this.alwaysPrepareQueries = alwaysPrepareQueries;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperties(String key, String value) {
            this.customProperties.put(Objects.requireNonNull(key, "customProperties key"), Objects.requireNonNull(value, "customProperties value"));
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperties(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.customProperties.put(Objects.requireNonNull(k, "customProperties key"), Objects.requireNonNull(v, "customProperties value"));
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends String> entries) {
            this.customProperties.clear();
            this.optBits |= 2L;
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.customProperties.put(Objects.requireNonNull(k, "customProperties key"), Objects.requireNonNull(v, "customProperties value"));
            }
            this.optBits |= 2L;
            return this;
        }

        public ImmutableDataStoreOptions build() {
            return ImmutableDataStoreOptions.validate(new ImmutableDataStoreOptions(this));
        }

        private boolean alwaysPrepareQueriesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean customPropertiesIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    @Generated(from="DataStoreOptions", generator="Immutables")
    private final class InitShim {
        private byte defaultParametersBuildStage = 0;
        private Parameters defaultParameters;
        private byte alwaysPrepareQueriesBuildStage = 0;
        private boolean alwaysPrepareQueries;
        private byte customPropertiesBuildStage = 0;
        private Map<String, String> customProperties;

        private InitShim() {
        }

        Parameters defaultParameters() {
            if (this.defaultParametersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultParametersBuildStage == 0) {
                this.defaultParametersBuildStage = (byte)-1;
                this.defaultParameters = Objects.requireNonNull(ImmutableDataStoreOptions.super.defaultParameters(), "defaultParameters");
                this.defaultParametersBuildStage = 1;
            }
            return this.defaultParameters;
        }

        void defaultParameters(Parameters defaultParameters) {
            this.defaultParameters = defaultParameters;
            this.defaultParametersBuildStage = 1;
        }

        boolean alwaysPrepareQueries() {
            if (this.alwaysPrepareQueriesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.alwaysPrepareQueriesBuildStage == 0) {
                this.alwaysPrepareQueriesBuildStage = (byte)-1;
                this.alwaysPrepareQueries = ImmutableDataStoreOptions.super.alwaysPrepareQueries();
                this.alwaysPrepareQueriesBuildStage = 1;
            }
            return this.alwaysPrepareQueries;
        }

        void alwaysPrepareQueries(boolean alwaysPrepareQueries) {
            this.alwaysPrepareQueries = alwaysPrepareQueries;
            this.alwaysPrepareQueriesBuildStage = 1;
        }

        Map<String, String> customProperties() {
            if (this.customPropertiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.customPropertiesBuildStage == 0) {
                this.customPropertiesBuildStage = (byte)-1;
                this.customProperties = ImmutableDataStoreOptions.createUnmodifiableMap(true, false, ImmutableDataStoreOptions.super.customProperties());
                this.customPropertiesBuildStage = 1;
            }
            return this.customProperties;
        }

        void customProperties(Map<String, String> customProperties) {
            this.customProperties = customProperties;
            this.customPropertiesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.defaultParametersBuildStage == -1) {
                attributes.add("defaultParameters");
            }
            if (this.alwaysPrepareQueriesBuildStage == -1) {
                attributes.add("alwaysPrepareQueries");
            }
            if (this.customPropertiesBuildStage == -1) {
                attributes.add("customProperties");
            }
            return "Cannot build DataStoreOptions, attribute initializers form cycle " + attributes;
        }
    }
}

