/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.datastore;

import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import io.stargate.db.Batch;
import io.stargate.db.BatchType;
import io.stargate.db.BoundStatement;
import io.stargate.db.Parameters;
import io.stargate.db.Persistence;
import io.stargate.db.SimpleStatement;
import io.stargate.db.Statement;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.DataStoreOptions;
import io.stargate.db.datastore.PersistenceBackedResultSet;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.query.BoundQuery;
import io.stargate.db.query.Query;
import io.stargate.db.query.TypedValue;
import io.stargate.db.schema.Schema;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.cassandra.stargate.exceptions.PreparedQueryNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PersistenceBackedDataStore
implements DataStore {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceBackedDataStore.class);
    private final Persistence.Connection connection;
    private final DataStoreOptions options;
    private final TypedValue.Codec valueCodec;

    PersistenceBackedDataStore(Persistence.Connection connection, DataStoreOptions options) {
        this.connection = connection;
        this.options = options;
        this.valueCodec = new TypedValue.Codec(this.parameters().protocolVersion(), connection.persistence());
    }

    private Parameters parameters() {
        return this.options.defaultParameters();
    }

    @Override
    public TypedValue.Codec valueCodec() {
        return this.valueCodec;
    }

    private Statement toPersistenceStatement(BoundQuery query) {
        List<TypedValue> values = query.values();
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(values.size());
        for (TypedValue value : values) {
            buffers.add(value.bytes());
        }
        Object boundedQuery = query.source().query();
        return boundedQuery.preparedId().isPresent() ? new BoundStatement(boundedQuery.preparedId().get(), buffers, null) : new SimpleStatement(boundedQuery.queryStringForPreparation(), buffers);
    }

    private void validateExecuteParameters(Parameters executeParameters) {
        if (this.parameters() == executeParameters) {
            return;
        }
        Preconditions.checkArgument(!executeParameters.skipMetadataInResult(), "Invalid execution parameters: you should not set 'skipMetadataInResult', thisis handled internally by DataStore.");
        Preconditions.checkArgument(executeParameters.protocolVersion() == this.parameters().protocolVersion(), "Invalid execution parameters: cannot modify the protocol version for execution (the DataStore version %s != %s, the execution parameters version).", (Object)this.parameters().protocolVersion(), (Object)executeParameters.protocolVersion());
    }

    @Override
    public <B extends BoundQuery> CompletableFuture<Query<B>> prepare(Query<B> query) {
        return this.connection.prepare(query.queryStringForPreparation(), this.parameters()).thenApply(prepared -> query.withPreparedId(prepared.statementId));
    }

    @Override
    public CompletableFuture<ResultSet> execute(BoundQuery query, UnaryOperator<Parameters> parametersModifier) {
        long queryStartNanos = System.nanoTime();
        Parameters executeParameters = (Parameters)parametersModifier.apply(this.parameters());
        this.validateExecuteParameters(executeParameters);
        CompletableFuture<ResultSet> future = new CompletableFuture<ResultSet>();
        if (query.source().query().preparedId().isPresent()) {
            this.executeWithRetry(query, executeParameters, queryStartNanos, future);
        } else if (this.options.alwaysPrepareQueries()) {
            this.prepareAndRetry(query.source(), executeParameters, queryStartNanos, future);
        } else {
            this.doExecute(query, executeParameters, queryStartNanos, future, future::completeExceptionally);
        }
        return future;
    }

    private void executeWithRetry(BoundQuery query, Parameters executeParameters, long queryStartNanos, CompletableFuture<ResultSet> future) {
        this.doExecute(query, executeParameters, queryStartNanos, future, ex -> {
            if (ex instanceof PreparedQueryNotFoundException) {
                logger.debug("Prepared statement (id={}) was invalid when executed. This can happen due to a conflicting schema change. Will re-prepare and retry.", (Object)((PreparedQueryNotFoundException)ex).id);
                this.prepareAndRetry(query.source(), executeParameters, queryStartNanos, future);
            } else {
                future.completeExceptionally((Throwable)ex);
            }
        });
    }

    private void doExecute(BoundQuery query, Parameters executeParameters, long queryStartNanos, CompletableFuture<ResultSet> successFuture, Consumer<Throwable> onException) {
        Statement statement = this.toPersistenceStatement(query);
        ((CompletableFuture)this.connection.execute(statement, executeParameters, queryStartNanos).thenAccept(r -> successFuture.complete(PersistenceBackedResultSet.create(this.connection, r, statement, executeParameters)))).exceptionally(ex -> {
            onException.accept((Throwable)ex);
            return null;
        });
    }

    private void prepareAndRetry(BoundQuery.Source<?> bound, Parameters executeParameters, long queryStartNanos, CompletableFuture<ResultSet> future) {
        ((CompletableFuture)this.prepare((Query)bound.query()).thenAccept(prepared -> this.executeWithRetry((BoundQuery)prepared.bindValues(bound.values()), executeParameters, queryStartNanos, future))).exceptionally(ex -> {
            future.completeExceptionally((Throwable)ex);
            return null;
        });
    }

    @Override
    public CompletableFuture<ResultSet> batch(Collection<BoundQuery> queries, BatchType batchType, UnaryOperator<Parameters> parametersModifier) {
        long queryStartNanos = System.nanoTime();
        Parameters executeParameters = (Parameters)parametersModifier.apply(this.parameters());
        this.validateExecuteParameters(executeParameters);
        List<Statement> persistenceStatements = queries.stream().map(this::toPersistenceStatement).collect(Collectors.toList());
        return this.batch(persistenceStatements, batchType, executeParameters, queryStartNanos);
    }

    private CompletableFuture<ResultSet> batch(List<Statement> statements, BatchType batchType, Parameters executeParameters, long queryStartNanos) {
        return this.connection.batch(new Batch(batchType, statements), executeParameters, queryStartNanos).thenApply(r -> PersistenceBackedResultSet.create(this.connection, r, null, executeParameters));
    }

    private Persistence persistence() {
        return this.connection.persistence();
    }

    @Override
    public Schema schema() {
        return this.persistence().schema();
    }

    @Override
    public boolean isInSchemaAgreement() {
        return this.persistence().isInSchemaAgreement();
    }

    @Override
    public boolean supportsSecondaryIndex() {
        return this.persistence().supportsSecondaryIndex();
    }

    @Override
    public boolean supportsSAI() {
        return this.persistence().supportsSAI();
    }

    @Override
    public boolean supportsLoggedBatches() {
        return this.persistence().supportsLoggedBatches();
    }

    @Override
    public void waitForSchemaAgreement() {
        this.persistence().waitForSchemaAgreement();
    }

    public String toString() {
        return String.format("DataStore[connection=%s, options=%s]", this.connection, this.options);
    }
}

