/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.datastore;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import io.stargate.db.PagingPosition;
import io.stargate.db.Parameters;
import io.stargate.db.Persistence;
import io.stargate.db.Result;
import io.stargate.db.Statement;
import io.stargate.db.datastore.ArrayListBackedRow;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.datastore.Row;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Keyspace;
import io.stargate.db.schema.Schema;
import io.stargate.db.schema.Table;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import javax.annotation.Nullable;

class PersistenceBackedResultSet
implements ResultSet {
    private final Persistence.Connection connection;
    private final Parameters parameters;
    @Nullable
    private final Statement statement;
    private final ProtocolVersion driverProtocolVersion;
    private final Deque<Row> fetchedRows;
    private final List<Column> columns;
    private Predicate<Row> authzFilter;
    private final Result.Rows initialPage;
    private ByteBuffer nextPagingState;

    PersistenceBackedResultSet(Persistence.Connection connection, Parameters parameters, @Nullable Statement statement, Result.Rows initialPage) {
        this(connection, parameters, statement, initialPage, null);
    }

    private PersistenceBackedResultSet(Persistence.Connection connection, Parameters parameters, Statement statement, Result.Rows initialPage, Predicate<Row> authzFilter) {
        this.connection = connection;
        this.parameters = parameters.withoutMetadataInResult();
        this.statement = statement;
        this.driverProtocolVersion = parameters.protocolVersion().toDriverVersion();
        this.fetchedRows = new ArrayDeque<Row>(parameters.pageSize().orElse(32));
        this.columns = this.processColumns(initialPage.resultMetadata.columns);
        this.authzFilter = authzFilter;
        this.processNewPage(initialPage);
        this.initialPage = initialPage;
        if (this.nextPagingState != null && this.statement == null) {
            throw new IllegalStateException("The statement must be provided if there is more than the initial page.");
        }
    }

    static ResultSet create(Persistence.Connection connection, Result result, @Nullable Statement statement, Parameters executeParameters) {
        switch (result.kind) {
            case Prepared: {
                throw new AssertionError((Object)"Shouldn't get a 'Prepared' result when executing a statement");
            }
            case SchemaChange: {
                connection.persistence().waitForSchemaAgreement();
                return ResultSet.empty(true);
            }
            case Void: 
            case SetKeyspace: {
                return ResultSet.empty();
            }
            case Rows: {
                return new PersistenceBackedResultSet(connection, executeParameters, statement, (Result.Rows)result);
            }
        }
        throw new AssertionError((Object)("Unhandled result type: " + (Object)((Object)result.kind)));
    }

    private List<Column> processColumns(List<Column> columns) {
        Schema schema = this.connection.persistence().schema();
        ArrayList<Column> processed = new ArrayList<Column>(columns.size());
        for (Column c : columns) {
            Column inSchema = PersistenceBackedResultSet.columnInSchema(schema, c);
            processed.add(inSchema == null ? c : inSchema);
        }
        return processed;
    }

    @Override
    public List<Column> columns() {
        return this.columns;
    }

    @Nullable
    private static Column columnInSchema(Schema schema, Column toFind) {
        Keyspace ks = schema.keyspace(toFind.keyspace());
        if (ks == null) {
            return null;
        }
        Table t = ks.table(toFind.table());
        if (t == null) {
            return null;
        }
        return t.column(toFind.name());
    }

    private void processNewPage(Result.Rows page) {
        for (List<ByteBuffer> rowValues : page.rows) {
            ArrayListBackedRow arrayListBackedRow = new ArrayListBackedRow(this.columns, rowValues, this.driverProtocolVersion);
            if (this.authzFilter != null && !this.authzFilter.test(arrayListBackedRow)) continue;
            this.fetchedRows.addLast(arrayListBackedRow);
        }
        this.nextPagingState = page.resultMetadata.pagingState;
    }

    private void fetchNextPage() {
        assert (this.nextPagingState != null);
        try {
            Result result = this.connection.execute(this.statement, this.parameters.withPagingState(this.nextPagingState), System.nanoTime()).get();
            switch (result.kind) {
                case Void: {
                    this.nextPagingState = null;
                    break;
                }
                case Rows: {
                    this.processNewPage((Result.Rows)result);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unexpected %s result received for a result set page", new Object[]{result.kind}));
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting on new page results");
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(cause);
        }
    }

    private boolean hasNextRow() {
        while (this.fetchedRows.isEmpty()) {
            if (this.nextPagingState == null) {
                return false;
            }
            this.fetchNextPage();
        }
        return true;
    }

    private Row nextRow() {
        Row nextRow;
        while ((nextRow = this.fetchedRows.pollFirst()) == null) {
            if (this.nextPagingState == null) {
                throw new NoSuchElementException();
            }
            this.fetchNextPage();
        }
        return nextRow;
    }

    @Override
    public ResultSet withRowInspector(Predicate<Row> authzFilter) {
        return new PersistenceBackedResultSet(this.connection, this.parameters, this.statement, this.initialPage, authzFilter);
    }

    @Override
    public Iterator<Row> iterator() {
        return new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                return PersistenceBackedResultSet.this.hasNextRow();
            }

            @Override
            public Row next() {
                return PersistenceBackedResultSet.this.nextRow();
            }
        };
    }

    @Override
    public Row one() {
        return this.nextRow();
    }

    @Override
    public List<Row> rows() {
        ArrayList<Row> all = new ArrayList<Row>();
        while (this.hasNextRow()) {
            all.add(this.nextRow());
        }
        return all;
    }

    @Override
    public List<Row> currentPageRows() {
        ArrayList<Row> fetched = new ArrayList<Row>();
        while (!this.fetchedRows.isEmpty()) {
            fetched.add(this.fetchedRows.pollFirst());
        }
        return fetched;
    }

    @Override
    public boolean hasNoMoreFetchedRows() {
        return this.fetchedRows.isEmpty();
    }

    @Override
    public ByteBuffer getPagingState() {
        return this.nextPagingState;
    }

    @Override
    public ByteBuffer makePagingState(PagingPosition position) {
        return this.connection.makePagingState(position, this.parameters);
    }

    @Override
    public boolean waitedForSchemaAgreement() {
        return false;
    }
}

