/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.datastore;

import io.stargate.db.AuthenticatedUser;
import io.stargate.db.ClientInfo;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.datastore.DataStoreOptions;
import io.stargate.db.datastore.PersistenceBackedDataStore;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PersistenceDataStoreFactory
implements DataStoreFactory {
    private final Persistence persistence;

    public PersistenceDataStoreFactory(Persistence persistence) {
        this.persistence = persistence;
    }

    private DataStore create(Persistence.Connection connection, @Nonnull DataStoreOptions options) {
        Objects.requireNonNull(options);
        return new PersistenceBackedDataStore(connection, options);
    }

    private DataStore create(@Nonnull AuthenticatedUser user, @Nonnull DataStoreOptions options, @Nullable ClientInfo clientInfo) {
        Persistence.Connection connection = clientInfo != null ? this.persistence.newConnection(clientInfo) : this.persistence.newConnection();
        connection.login(user);
        Map<String, String> customProperties = user.customProperties();
        if (customProperties != null && !customProperties.isEmpty()) {
            options = DataStoreOptions.builder().from(options).putAllCustomProperties(customProperties).build();
        }
        if (options.customProperties() != null) {
            connection.setCustomProperties(options.customProperties());
        }
        return this.create(connection, options);
    }

    @Override
    public DataStore create(@Nonnull AuthenticatedUser user, @Nonnull DataStoreOptions options) {
        ClientInfo clientInfo = null;
        if (!user.isFromExternalAuth()) {
            clientInfo = new ClientInfo(new InetSocketAddress("127.0.0.1", 0), null);
        }
        return this.create(user, options, clientInfo);
    }

    @Override
    public DataStore createInternal() {
        return this.createInternal(DataStoreOptions.defaults());
    }

    @Override
    public DataStore createInternal(DataStoreOptions options) {
        Persistence.Connection connection = this.persistence.newConnection();
        return this.create(connection, options);
    }
}

