/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query;

import io.stargate.db.query.ImmutableBindMarker;
import io.stargate.db.schema.Column;
import java.util.Objects;
import org.immutables.value.Value;

@Value.Immutable
@Value.Style(visibility=Value.Style.ImplementationVisibility.PACKAGE)
public interface BindMarker {
    public String receiver();

    public Column.ColumnType type();

    public static BindMarker markerFor(String receiver, Column.ColumnType type) {
        return ImmutableBindMarker.builder().receiver(receiver).type(type).build();
    }

    public static BindMarker markerFor(Column column) {
        Objects.requireNonNull(column.name(), "The column for a bind marker must have a name");
        Objects.requireNonNull(column.type(), "The column for a bind marker must have a type");
        return BindMarker.markerFor(column.name(), column.type());
    }
}

