/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query;

import io.stargate.db.query.SchemaKey;
import io.stargate.db.query.TypedValue;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Table;
import java.util.List;

public class PartitionKey
extends SchemaKey {
    public PartitionKey(Table table, List<TypedValue> values) {
        super(table, values);
    }

    @Override
    protected String keyName() {
        return "partition key";
    }

    @Override
    protected int columnIndex(Column column) {
        int idx = this.table.primaryKeyColumnIndex(column);
        if (idx >= this.table.partitionKeyColumns().size()) {
            throw new IllegalArgumentException(String.format("Column %s is not a partition key column of %s.%s", column, this.table.cqlKeyspace(), this.table.cqlName()));
        }
        return idx;
    }

    @Override
    public List<Column> allColumns() {
        return this.table.partitionKeyColumns();
    }
}

