/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query;

import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import io.stargate.db.query.PartitionKey;
import io.stargate.db.query.PrimaryKey;
import io.stargate.db.query.RowsRange;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class RowsImpacted {
    @Nullable
    private Set<PartitionKey> partitionKeys;

    private RowsImpacted() {
    }

    public abstract boolean isRanges();

    public boolean isKeys() {
        return !this.isRanges();
    }

    public Keys asKeys() {
        Preconditions.checkState(this.isKeys());
        return (Keys)this;
    }

    public Ranges asRanges() {
        Preconditions.checkState(this.isRanges());
        return (Ranges)this;
    }

    public Set<PartitionKey> partitionKeys() {
        if (this.partitionKeys == null) {
            this.partitionKeys = this.computePartitionKeys();
        }
        return this.partitionKeys;
    }

    protected abstract Set<PartitionKey> computePartitionKeys();

    public static final class Ranges
    extends RowsImpacted {
        private final List<RowsRange> rowsRanges;

        public Ranges(List<RowsRange> rowsRanges) {
            this.rowsRanges = rowsRanges;
        }

        public List<RowsRange> ranges() {
            return this.rowsRanges;
        }

        @Override
        public boolean isRanges() {
            return true;
        }

        @Override
        protected Set<PartitionKey> computePartitionKeys() {
            HashSet<PartitionKey> partitionKeys = new HashSet<PartitionKey>();
            this.rowsRanges.forEach(pk -> partitionKeys.add(pk.partitionKey()));
            return partitionKeys;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Ranges)) {
                return false;
            }
            Ranges ranges = (Ranges)o;
            return this.rowsRanges.equals(ranges.rowsRanges);
        }

        public int hashCode() {
            return Objects.hash(this.rowsRanges);
        }
    }

    public static final class Keys
    extends RowsImpacted {
        private final List<PrimaryKey> primaryKeys;

        public Keys(List<PrimaryKey> primaryKeys) {
            this.primaryKeys = primaryKeys;
        }

        public List<PrimaryKey> primaryKeys() {
            return this.primaryKeys;
        }

        @Override
        public boolean isRanges() {
            return false;
        }

        @Override
        protected Set<PartitionKey> computePartitionKeys() {
            if (this.primaryKeys.size() == 1) {
                return Collections.singleton(this.primaryKeys.get(0).partitionKey());
            }
            HashSet<PartitionKey> partitionKeys = new HashSet<PartitionKey>();
            this.primaryKeys.forEach(pk -> partitionKeys.add(pk.partitionKey()));
            return partitionKeys;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Keys)) {
                return false;
            }
            Keys keys = (Keys)o;
            return this.primaryKeys.equals(keys.primaryKeys);
        }

        public int hashCode() {
            return Objects.hash(this.primaryKeys);
        }

        public String toString() {
            return this.primaryKeys.toString();
        }
    }
}

