/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query.builder;

import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import io.stargate.db.query.BindMarker;
import io.stargate.db.query.Predicate;
import io.stargate.db.query.builder.ImmutableBuiltCondition;
import io.stargate.db.query.builder.QueryStringBuilder;
import io.stargate.db.query.builder.Value;
import io.stargate.db.query.builder.ValueModifier;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ColumnUtils;
import io.stargate.db.schema.Table;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.immutables.value.Value;

@Value.Immutable(prehash=true)
@Value.Style(visibility=Value.Style.ImplementationVisibility.PACKAGE)
public abstract class BuiltCondition {
    public abstract LHS lhs();

    public abstract Predicate predicate();

    public abstract Value<?> value();

    public static BuiltCondition of(String columnName, Predicate predicate, Object value) {
        return BuiltCondition.of(LHS.column(columnName), predicate, value);
    }

    public static BuiltCondition of(LHS lhs, Predicate predicate, Object value) {
        return ImmutableBuiltCondition.builder().lhs(lhs).predicate(predicate).value(Value.of(value)).build();
    }

    public static BuiltCondition ofMarker(String columnName, Predicate predicate) {
        return BuiltCondition.ofMarker(LHS.column(columnName), predicate);
    }

    public static BuiltCondition ofMarker(LHS lhs, Predicate predicate) {
        return ImmutableBuiltCondition.builder().lhs(lhs).predicate(predicate).value(Value.marker()).build();
    }

    public static BuiltCondition ofModifier(ValueModifier modifier) {
        return ImmutableBuiltCondition.builder().lhs(LHS.column(modifier.target().columnName())).predicate(Predicate.EQ).value(modifier.value()).build();
    }

    void addToBuilder(Table table, QueryStringBuilder builder, Consumer<BindMarker> onMarker) {
        BindMarker marker;
        Column receiver = this.lhs().appendToBuilder(table, builder, onMarker);
        builder.append(this.predicate().toString());
        Column.ColumnType type = receiver.type();
        assert (type != null);
        switch (this.predicate()) {
            case EQ: {
                if (this.lhs().isMapAccess()) {
                    marker = BindMarker.markerFor(String.format("value(%s)", receiver.name()), type);
                    builder.append(marker, this.value());
                    break;
                }
            }
            case LT: 
            case GT: 
            case LTE: 
            case GTE: 
            case NEQ: {
                marker = BindMarker.markerFor(receiver);
                builder.append(marker, this.value());
                break;
            }
            case IN: {
                marker = BindMarker.markerFor(String.format("IN(%s)", receiver.name()), Column.Type.List.of(type));
                builder.appendInValue(marker, this.value());
                break;
            }
            case CONTAINS: {
                Preconditions.checkArgument(type.isCollection(), "CONTAINS predicate on %s is invalid: CONTAINS can only apply to a collection, but %s is of type %s", (Object)receiver.cqlName(), (Object)receiver.cqlName(), (Object)type.cqlDefinition());
                Column.ColumnType valueType = type.isMap() ? type.parameters().get(1) : type.parameters().get(0);
                marker = BindMarker.markerFor(String.format("value(%s)", receiver.name()), valueType);
                builder.append(marker, this.value());
                break;
            }
            case CONTAINS_KEY: {
                Preconditions.checkArgument(type.isMap(), "CONTAINS KEY predicate on %s is invalid: CONTAINS KEY can only apply to a map, but %s is of type %s", (Object)receiver.cqlName(), (Object)receiver.cqlName(), (Object)type.cqlDefinition());
                marker = BindMarker.markerFor(String.format("key(%s)", receiver.name()), type.parameters().get(0));
                builder.append(marker, this.value());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        onMarker.accept(marker);
    }

    public String toString() {
        return String.format("%s %s %s", new Object[]{this.lhs(), this.predicate(), this.value()});
    }

    public static abstract class LHS {
        public static LHS column(String columnName) {
            return new ColumnName(columnName);
        }

        public static LHS mapAccess(String columnName, Object key) {
            return new MapElement(columnName, Value.of(key));
        }

        public static LHS mapAccess(String columnName) {
            return new MapElement(columnName, Value.marker());
        }

        public static LHS columnTuple(String ... columnNames) {
            throw new UnsupportedOperationException();
        }

        public static LHS token(String ... columnNames) {
            throw new UnsupportedOperationException();
        }

        abstract Column appendToBuilder(Table var1, QueryStringBuilder var2, Consumer<BindMarker> var3);

        abstract String columnName();

        Optional<Value<?>> value() {
            return Optional.empty();
        }

        boolean isColumnName() {
            return false;
        }

        boolean isMapAccess() {
            return false;
        }

        static final class MapElement
        extends LHS {
            private final String columnName;
            private final Value<?> keyValue;

            private MapElement(String columnName, Value<?> keyValue) {
                this.columnName = columnName;
                this.keyValue = keyValue;
            }

            @Override
            String columnName() {
                return this.columnName;
            }

            Value<?> keyValue() {
                return this.keyValue;
            }

            @Override
            Optional<Value<?>> value() {
                return Optional.of(this.keyValue);
            }

            @Override
            Column appendToBuilder(Table table, QueryStringBuilder builder, Consumer<BindMarker> onMarker) {
                Column column = table.existingColumn(this.columnName);
                Column.ColumnType type = column.type();
                assert (type != null);
                Preconditions.checkArgument(type.isMap(), "Invalid access by key on column %s of type %s: accessing keys only works on map", (Object)column.cqlName(), (Object)type.cqlDefinition());
                builder.append(column).appendForceNoSpace("[");
                Column.ColumnType keyType = type.parameters().get(0);
                BindMarker keyMarker = BindMarker.markerFor(String.format("key(%s)", column.name()), keyType);
                builder.append(keyMarker, this.keyValue).append("]");
                onMarker.accept(keyMarker);
                return Column.create(String.format("value(%s)", column.name()), type.parameters().get(1));
            }

            @Override
            boolean isMapAccess() {
                return true;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof MapElement)) {
                    return false;
                }
                MapElement that = (MapElement)o;
                return this.columnName.equals(that.columnName) && this.keyValue.equals(that.keyValue);
            }

            public int hashCode() {
                return Objects.hash(this.columnName, this.keyValue);
            }

            public String toString() {
                return String.format("%s[%s]", ColumnUtils.maybeQuote(this.columnName), this.keyValue);
            }
        }

        static final class ColumnName
        extends LHS {
            private final String columnName;

            private ColumnName(String columnName) {
                this.columnName = columnName;
            }

            @Override
            String columnName() {
                return this.columnName;
            }

            @Override
            boolean isColumnName() {
                return true;
            }

            @Override
            Column appendToBuilder(Table table, QueryStringBuilder builder, Consumer<BindMarker> onMarker) {
                Column column = table.existingColumn(this.columnName);
                builder.append(column);
                return column;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof ColumnName)) {
                    return false;
                }
                ColumnName that = (ColumnName)o;
                return this.columnName.equals(that.columnName);
            }

            public int hashCode() {
                return Objects.hash(this.columnName);
            }

            public String toString() {
                return ColumnUtils.maybeQuote(this.columnName);
            }
        }
    }
}

