/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query.builder;

import io.stargate.db.query.builder.ImmutableColumnOrder;
import io.stargate.db.schema.Column;
import org.immutables.value.Value;

@Value.Immutable(prehash=true)
@Value.Style(visibility=Value.Style.ImplementationVisibility.PACKAGE)
public abstract class ColumnOrder {
    public abstract String column();

    public abstract Column.Order order();

    public static ColumnOrder of(Column column, Column.Order order) {
        return ColumnOrder.of(column.name(), order);
    }

    public static ColumnOrder of(Column column) {
        return ColumnOrder.of(column.name());
    }

    public static ColumnOrder of(String column, Column.Order order) {
        return ImmutableColumnOrder.builder().column(column).order(order).build();
    }

    public static ColumnOrder of(String column) {
        return ColumnOrder.of(column, Column.Order.ASC);
    }

    public String toString() {
        return this.column() + " " + (Object)((Object)this.order());
    }
}

