/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query.builder;

import java.util.Map;

public class Replication {
    private final String replication;

    private Replication(String replication) {
        this.replication = replication;
    }

    public static Replication simpleStrategy(int replicationFactor) {
        return new Replication(String.format("{ 'class': 'SimpleStrategy', 'replication_factor': %d }", replicationFactor));
    }

    public static Replication networkTopologyStrategy(Map<String, Integer> dataCenterReplicationFactors) {
        StringBuilder sb = new StringBuilder();
        sb.append("{ 'class' : 'NetworkTopologyStrategy'");
        for (Map.Entry<String, Integer> entry : dataCenterReplicationFactors.entrySet()) {
            String dcName = entry.getKey();
            int dcReplication = entry.getValue();
            sb.append(", '").append(dcName).append("': ").append(dcReplication);
        }
        sb.append(" }");
        return new Replication(sb.toString());
    }

    public String toString() {
        return this.replication;
    }
}

