/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ColumnUtils;
import io.stargate.db.schema.Index;
import io.stargate.db.schema.QualifiedSchemaEntity;
import io.stargate.db.schema.SchemaEntity;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.immutables.value.Value;

public abstract class AbstractTable
implements Index,
QualifiedSchemaEntity {
    private static final long serialVersionUID = -5320339139947924742L;

    public abstract List<Column> columns();

    @Value.Lazy
    Map<String, Column> columnMap() {
        return this.columns().stream().collect(Collectors.toMap(SchemaEntity::name, Function.identity()));
    }

    @Value.Lazy
    public List<Column> partitionKeyColumns() {
        return ImmutableList.copyOf(this.columns().stream().filter(c -> c.kind() == Column.Kind.PartitionKey).collect(Collectors.toList()));
    }

    @Value.Lazy
    public List<Column> clusteringKeyColumns() {
        return ImmutableList.copyOf(this.columns().stream().filter(c -> c.kind() == Column.Kind.Clustering).collect(Collectors.toList()));
    }

    @Value.Lazy
    public List<Column> primaryKeyColumns() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(this.partitionKeyColumns())).addAll(this.clusteringKeyColumns())).build();
    }

    @Value.Lazy
    public List<Column> regularAndStaticColumns() {
        return ImmutableList.copyOf(this.columns().stream().filter(c -> c.kind() == Column.Kind.Regular || c.kind() == Column.Kind.Static).collect(Collectors.toList()));
    }

    @Value.Lazy
    public Set<Column> getRequiredIndexColumns() {
        return ((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.partitionKeyColumns())).build();
    }

    @Value.Lazy
    public Set<Column> getOptionalIndexColumns() {
        return ((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.clusteringKeyColumns())).build();
    }

    public int primaryKeyColumnIndex(Column column) {
        List<Column> pks = this.primaryKeyColumns();
        for (int i = 0; i < pks.size(); ++i) {
            if (!column.name().equals(pks.get(i).name())) continue;
            return i;
        }
        throw new IllegalArgumentException(String.format("Column %s is not a primary key column of %s.%s", column, this.cqlKeyspace(), this.cqlName()));
    }

    public Column column(String name) {
        if (Column.TTL.name().equals(name)) {
            return Column.TTL;
        }
        if (Column.TIMESTAMP.name().equals(name)) {
            return Column.TIMESTAMP;
        }
        return this.columnMap().get(name);
    }

    public Column existingColumn(String name) {
        Column column = this.column(name);
        if (column == null) {
            throw new IllegalArgumentException(String.format("Cannot find column %s in table %s.%s", ColumnUtils.maybeQuote(name), this.cqlKeyspace(), this.cqlName()));
        }
        return column;
    }
}

