/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.internal.core.type.codec.registry.DefaultCodecRegistry;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import io.stargate.db.schema.ColumnUtils;
import io.stargate.db.schema.ImmutableColumn;
import io.stargate.db.schema.ImmutableListType;
import io.stargate.db.schema.ImmutableMapType;
import io.stargate.db.schema.ImmutableSetType;
import io.stargate.db.schema.ImmutableTupleType;
import io.stargate.db.schema.ImmutableUserDefinedType;
import io.stargate.db.schema.Keyspace;
import io.stargate.db.schema.LineString;
import io.stargate.db.schema.NumberCoercion;
import io.stargate.db.schema.ParameterizedType;
import io.stargate.db.schema.Point;
import io.stargate.db.schema.Polygon;
import io.stargate.db.schema.SchemaEntity;
import io.stargate.db.schema.UserDefinedType;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Value.Immutable(prehash=true)
public abstract class Column
implements SchemaEntity,
Comparable<Column> {
    private static final long serialVersionUID = 2199514488330101566L;
    public static final CodecRegistry CODEC_REGISTRY = new DefaultCodecRegistry("persistence-codec-registry");
    public static final Column TTL = Column.create("[ttl]", Type.Int);
    public static final Column TIMESTAMP = Column.create("[timestamp]", Type.Bigint);
    private static final Map<Class<?>, Type> TYPE_MAPPING = ImmutableMap.builder().put(Date.class, Type.Date).putAll(Arrays.stream(Type.values()).filter(r -> !r.isCollection() && r != Type.Counter && r != Type.Ascii && r != Type.Timeuuid && r != Type.Varchar).collect(Collectors.toMap(r -> Type.access$400(r), r -> r))).build();

    private static String toCQLString(ColumnType type, Object value) {
        if (value == null) {
            return "null";
        }
        TypeCodec codec = type.codec();
        try {
            return codec.format(type.validate(value, "unknown"));
        }
        catch (Exception e) {
            if (!codec.accepts(value)) {
                throw new IllegalArgumentException(String.format("Java value %s of type '%s' is not a valid value for CQL type %s", value, value.getClass().getName(), type.cqlDefinition()), e);
            }
            throw new IllegalStateException(e);
        }
    }

    @Nullable
    public abstract ColumnType type();

    public boolean ofTypeText() {
        return Column.ofTypeText(this.type());
    }

    public static boolean ofTypeText(ColumnType type) {
        return Type.Varchar.equals(type) || Type.Text.equals(type);
    }

    public boolean ofTypeListOrSet() {
        return Column.ofTypeListOrSet(this.type());
    }

    public static boolean ofTypeListOrSet(ColumnType type) {
        return null != type && (Type.Set.equals(type.rawType()) || Type.List.equals(type.rawType()));
    }

    public boolean ofTypeMap() {
        return Column.ofTypeMap(this.type());
    }

    public static boolean ofTypeMap(ColumnType type) {
        return null != type && Type.Map.equals(type.rawType());
    }

    public boolean isCollection() {
        return this.ofTypeMap() || this.ofTypeListOrSet();
    }

    public boolean isFrozenCollection() {
        return Column.isFrozenCollection(this.type());
    }

    public static boolean isFrozenCollection(ColumnType type) {
        return null != type && type.isFrozen() && type.isCollection();
    }

    @Nullable
    public abstract Kind kind();

    @Nullable
    public abstract String keyspace();

    @Nullable
    public abstract String table();

    public Column reference() {
        return Column.reference(this.name());
    }

    public static Column reference(String name) {
        return ImmutableColumn.builder().name(name).build();
    }

    public static Column create(String name, Kind kind) {
        return ImmutableColumn.builder().name(name).kind(kind).build();
    }

    public static Column create(String name, ColumnType type) {
        return ImmutableColumn.builder().name(name).type(type).kind(Kind.Regular).build();
    }

    public static Column create(String name, Kind kind, ColumnType type) {
        return ImmutableColumn.builder().name(name).kind(kind).type(type).build();
    }

    public static Column create(String name, Kind kind, ColumnType type, Order order) {
        if (kind == Kind.Clustering && order == null) {
            order = Order.ASC;
        }
        return ImmutableColumn.builder().name(name).kind(kind).type(type).order(order).build();
    }

    public boolean isPrimaryKeyComponent() {
        Kind kind = this.kind();
        return kind != null && kind.isPrimaryKeyKind();
    }

    public boolean isPartitionKey() {
        return this.kind() == Kind.PartitionKey;
    }

    public boolean isClusteringKey() {
        return this.kind() == Kind.Clustering;
    }

    @Nullable
    @Value.Default
    public Order order() {
        if (this.kind() == Kind.Clustering) {
            return Order.ASC;
        }
        return null;
    }

    @Override
    public int compareTo(Column other) {
        Kind thatKind;
        Kind thisKind = this.kind();
        if (thisKind.equals((Object)(thatKind = other.kind()))) {
            return this.name().compareTo(other.name());
        }
        return thisKind == null ? -1 : thisKind.compareTo(thatKind);
    }

    private static ColumnType maybeFreezeComplexSubtype(ColumnType type) {
        if (type.isComplexType() && !type.isFrozen()) {
            return type.frozen();
        }
        return type;
    }

    public static interface Builder {
        default public ImmutableColumn.Builder type(Class<?> type) {
            Type cqlType = (Type)TYPE_MAPPING.get(type);
            Preconditions.checkArgument(cqlType != null, "Tried to set the type for '%s', but this is not a valid CQL type", (Object)type.getSimpleName());
            return this.type(cqlType);
        }

        public ImmutableColumn.Builder type(@Nullable ColumnType var1);
    }

    public static enum Kind {
        PartitionKey,
        Clustering,
        Regular,
        Static;


        public boolean isPrimaryKeyKind() {
            return this == PartitionKey || this == Clustering;
        }
    }

    public static class ValidationException
    extends Exception {
        private final String providedType;
        private final String expectedType;
        private final String expectedCqlType;
        private final String location;
        private final String errorDetails;

        public ValidationException(Class<?> providedType, ColumnType expectedType, String location) {
            this(providedType, expectedType, "", location);
        }

        public ValidationException(ColumnType expectedType, String location) {
            this("<invalid>", expectedType, "", location);
        }

        public ValidationException(Class<?> providedType, ColumnType expectedType, String errorMessage, String location) {
            this(providedType.getSimpleName(), expectedType, errorMessage, location);
        }

        private ValidationException(String providedType, ColumnType expectedType, String errorMessage, String location) {
            super("Wanted '" + expectedType.cqlDefinition() + "' but got '" + errorMessage + "' at location '" + location + "'");
            this.providedType = providedType;
            this.expectedType = expectedType.javaType().getSimpleName();
            this.expectedCqlType = expectedType.cqlDefinition();
            this.location = location;
            this.errorDetails = "".equals(errorMessage) ? "" : " Reason: " + errorMessage + ".";
        }

        public String providedType() {
            return this.providedType;
        }

        public String expectedType() {
            return this.expectedType;
        }

        public String expectedCqlType() {
            return this.expectedCqlType;
        }

        public String location() {
            return this.location;
        }

        public String errorDetails() {
            return this.errorDetails;
        }
    }

    public static enum Type implements ColumnType
    {
        Ascii(1, String.class, true, "US-ASCII characters"),
        Bigint(2, Long.class, false, "64-bit signed integer"),
        Blob(3, ByteBuffer.class, false, "Arbitrary bytes"),
        Boolean(4, Boolean.class, false, "True or false"),
        Counter(5, Long.class, false, "64-bit signed integer"),
        Date(17, LocalDate.class, true, "32-bit unsigned integer representing the number of days since epoch"),
        Decimal(6, BigDecimal.class, false, "Variable-precision decimal, supports integers and floats"),
        Double(7, Double.class, false, "64-bit IEEE-754 floating point"),
        Duration(21, CqlDuration.class, false, "128 bit encoded duration with nanosecond precision"),
        Float(8, Float.class, false, "32-bit IEEE-754 floating point"),
        Inet(16, InetAddress.class, true, "IP address string in IPv4 or IPv6 format"),
        Int(9, Integer.class, false, "32-bit signed integer"),
        List(32, (Class)List.class, false, "listOf(<type>)", "A typed list of values"){

            @Override
            public ColumnType of(ColumnType ... types) {
                Preconditions.checkArgument(types.length == 1, "Lists must have one type parameter");
                ImmutableListType.Builder builder = ImmutableListType.builder();
                for (ColumnType colType : types) {
                    builder.addParameters(Column.maybeFreezeComplexSubtype(colType));
                }
                return builder.build();
            }

            @Override
            public ParameterizedType.Builder builder() {
                return ImmutableListType.builder();
            }

            @Override
            public boolean isParameterized() {
                return true;
            }

            @Override
            public boolean isCollection() {
                return true;
            }

            @Override
            public boolean isList() {
                return true;
            }
        }
        ,
        Map(33, (Class)Map.class, false, "mapOf(<type>, <type>)", "A typed map of key value pairs"){

            @Override
            public ColumnType of(ColumnType ... types) {
                Preconditions.checkArgument(types.length == 2, "Maps must have two type parameters");
                ImmutableMapType.Builder builder = ImmutableMapType.builder();
                for (ColumnType colType : types) {
                    builder.addParameters(Column.maybeFreezeComplexSubtype(colType));
                }
                return builder.build();
            }

            @Override
            public ParameterizedType.Builder builder() {
                return ImmutableMapType.builder();
            }

            @Override
            public boolean isParameterized() {
                return true;
            }

            @Override
            public boolean isCollection() {
                return true;
            }

            @Override
            public boolean isMap() {
                return true;
            }
        }
        ,
        Set(34, (Class)Set.class, false, "setOf(<type>)", "A typed set of values"){

            @Override
            public ColumnType of(ColumnType ... types) {
                Preconditions.checkArgument(types.length == 1, "Sets must have one type parameter");
                ImmutableSetType.Builder builder = ImmutableSetType.builder();
                for (ColumnType colType : types) {
                    builder.addParameters(Column.maybeFreezeComplexSubtype(colType));
                }
                return builder.build();
            }

            @Override
            public ParameterizedType.Builder builder() {
                return ImmutableSetType.builder();
            }

            @Override
            public boolean isParameterized() {
                return true;
            }

            @Override
            public boolean isCollection() {
                return true;
            }

            @Override
            public boolean isSet() {
                return true;
            }
        }
        ,
        Smallint(19, Short.class, false, "16-bit signed integer"),
        Text(10, String.class, true, "UTF-8 encoded string"),
        Time(18, LocalTime.class, true, "Encoded 64-bit signed integers representing the number of nanoseconds since midnight with no corresponding date value"),
        Timestamp(11, Instant.class, true, "64-bit signed integer representing the date and time since epoch (January 1 1970 at 00:00:00 GMT) in milliseconds"),
        Timeuuid(15, UUID.class, false, "Version 1 UUID; unique identifier that includes a 'conflict-free' timestamp"),
        Tinyint(20, Byte.class, false, "8-bit signed integer"),
        Tuple(49, (Class)TupleValue.class, false, "tupleOf(<type>...)", "Fixed length sequence of elements of different types"){

            @Override
            public ColumnType of(ColumnType ... types) {
                ImmutableTupleType.Builder builder = ImmutableTupleType.builder();
                for (ColumnType colType : types) {
                    builder.addParameters(Column.maybeFreezeComplexSubtype(colType));
                }
                return builder.build();
            }

            @Override
            public ParameterizedType.Builder builder() {
                return ImmutableTupleType.builder();
            }

            @Override
            public boolean isParameterized() {
                return true;
            }

            @Override
            public boolean isTuple() {
                return true;
            }
        }
        ,
        Uuid(12, UUID.class, false, "128 bit universally unique identifier (UUID)"),
        Varchar(13, String.class, true, "UTF-8 encoded string"),
        Varint(14, BigInteger.class, false, "Arbitrary-precision integer"),
        Point(0, Point.class, "org.apache.cassandra.db.marshal.PointType", true, null, "Contains two coordinate values for latitude and longitude"),
        Polygon(0, Polygon.class, "org.apache.cassandra.db.marshal.PolygonType", true, null, "Contains three or more point values forming a polygon"),
        LineString(0, LineString.class, "org.apache.cassandra.db.marshal.LineStringType", true, null, "Contains two or more point values forming a line"),
        UDT(48, (Class)UdtValue.class, false, "typeOf(<user_type>)", "A user defined type that has been set up previously via 'schema.type(<type_name>).property(<prop_name>, <type>)...create()'"){

            @Override
            public boolean isUserDefined() {
                return true;
            }
        };

        private final int id;
        private final String usage;
        private String description;
        private Class<?> javaType;
        private final String marshalTypeName;
        private boolean requiresQuotes;
        private static final Type[] ids;

        private Type(int id, Class<?> javaType, boolean requiresQuotes, String usage, String description) {
            this(id, javaType, null, requiresQuotes, usage, description);
        }

        private Type(int id, Class<?> javaType, String marshalTypeName, boolean requiresQuotes, String usage, String description) {
            this.id = id;
            this.marshalTypeName = marshalTypeName;
            this.javaType = javaType;
            this.requiresQuotes = requiresQuotes;
            this.description = description;
            this.usage = usage;
        }

        public static Type fromId(int id) {
            return ids[id];
        }

        private Type(int id, Class<?> javaType, boolean requiresQuotes, String description) {
            this(id, javaType, requiresQuotes, null, description);
        }

        @Override
        public Class<?> javaType() {
            return this.javaType;
        }

        @Override
        public String marshalTypeName() {
            return this.marshalTypeName;
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public Type rawType() {
            return this;
        }

        @Override
        public String cqlDefinition() {
            if (this.marshalTypeName != null) {
                return "'" + this.marshalTypeName + "'";
            }
            return this.name().toLowerCase();
        }

        @Override
        public boolean isFrozen() {
            return false;
        }

        public static ColumnType fromCqlDefinitionOf(Keyspace keyspace, String dataTypeName) {
            return Type.fromCqlDefinitionOf(keyspace, dataTypeName, true);
        }

        public static ColumnType fromCqlDefinitionOf(Keyspace keyspace, String dataTypeName, boolean strict) {
            boolean isParameterized;
            String baseTypeName;
            if ((dataTypeName = dataTypeName.trim()).isEmpty()) {
                throw new IllegalArgumentException("Invalid empty type name");
            }
            if (dataTypeName.charAt(0) == '\'') {
                throw new IllegalArgumentException("Custom types are not supported");
            }
            int lastCharIdx = dataTypeName.length() - 1;
            if (dataTypeName.charAt(0) == '\"') {
                if (dataTypeName.charAt(lastCharIdx) != '\"' || dataTypeName.length() < 3) {
                    throw new IllegalArgumentException("Malformed type name: " + dataTypeName);
                }
                String udtName = dataTypeName.substring(1, lastCharIdx).replaceAll("\"\"", "\"");
                return Type.findUDTType(keyspace, udtName, strict);
            }
            int paramsIdx = dataTypeName.indexOf(60);
            String string = baseTypeName = paramsIdx < 0 ? dataTypeName : dataTypeName.substring(0, paramsIdx).trim();
            if (!ColumnUtils.isValidUnquotedIdentifier(baseTypeName)) {
                throw new IllegalArgumentException("Malformed type name: " + dataTypeName);
            }
            Type baseType = Type.parseBaseType(baseTypeName);
            boolean isFrozen = baseType == null && baseTypeName.equalsIgnoreCase("frozen");
            boolean bl = isParameterized = isFrozen || baseType != null && baseType.isParameterized();
            if (isParameterized) {
                if (paramsIdx < 0) {
                    throw new IllegalArgumentException(String.format("Malformed type name: type %s is missing its type parameters", baseTypeName));
                }
                if (dataTypeName.charAt(lastCharIdx) != '>') {
                    throw new IllegalArgumentException(String.format("Malformed type name: parameters for type %s are missing a closing '>'", baseTypeName));
                }
                String paramsString = dataTypeName.substring(paramsIdx + 1, lastCharIdx);
                List<ColumnType> parameters = Type.splitAndParseParameters(dataTypeName, keyspace, paramsString, strict);
                if (isFrozen) {
                    if (parameters.size() != 1) {
                        throw new IllegalArgumentException(String.format("Malformed type name: frozen takes only 1 parameter, but %d provided", parameters.size()));
                    }
                    return parameters.get(0).frozen();
                }
                return baseType.of(parameters.toArray(new ColumnType[0]));
            }
            if (paramsIdx >= 0) {
                throw new IllegalArgumentException(String.format("Malformed type name: type %s cannot have parameters", baseTypeName));
            }
            return baseType == null ? Type.findUDTType(keyspace, baseTypeName, strict) : baseType;
        }

        private static List<ColumnType> splitAndParseParameters(String fullTypeName, Keyspace keyspace, String parameters, boolean strict) {
            int currentStart;
            int idx;
            int openParam = 0;
            ArrayList<ColumnType> parsedParameters = new ArrayList<ColumnType>();
            block6: for (idx = currentStart = 0; idx < parameters.length(); ++idx) {
                switch (parameters.charAt(idx)) {
                    case ',': {
                        if (openParam != 0) continue block6;
                        parsedParameters.add(Type.extractParameter(fullTypeName, keyspace, parameters, currentStart, idx, strict));
                        currentStart = idx + 1;
                        continue block6;
                    }
                    case '<': {
                        ++openParam;
                        continue block6;
                    }
                    case '>': {
                        if (--openParam >= 0) continue block6;
                        throw new IllegalArgumentException("Malformed type name: " + fullTypeName + " (unmatched closing '>')");
                    }
                    case '\"': {
                        idx = Type.findClosingDoubleQuote(fullTypeName, parameters, idx + 1) - 1;
                    }
                }
            }
            parsedParameters.add(Type.extractParameter(fullTypeName, keyspace, parameters, currentStart, idx, strict));
            return parsedParameters;
        }

        private static ColumnType extractParameter(String fullTypeName, Keyspace keyspace, String parameters, int start, int end, boolean strict) {
            String parameterStr = parameters.substring(start, end);
            if (parameterStr.isEmpty()) {
                throw new IllegalArgumentException("Malformed type name: " + fullTypeName);
            }
            return Type.fromCqlDefinitionOf(keyspace, parameterStr, strict);
        }

        private static int findClosingDoubleQuote(String fullTypeName, String str, int startIdx) {
            for (int idx = startIdx; idx < str.length(); ++idx) {
                if (str.charAt(idx) != '\"' || ++idx < str.length() && str.charAt(idx) == '\"') continue;
                return idx;
            }
            throw new IllegalArgumentException("Malformed type name: " + fullTypeName);
        }

        private static UserDefinedType findUDTType(Keyspace keyspace, String udtName, boolean strict) {
            UserDefinedType udt = keyspace.userDefinedType(udtName);
            if (udt == null) {
                if (strict) {
                    throw new IllegalArgumentException(String.format("Cannot find user type %s int keyspace %s", ColumnUtils.maybeQuote(udtName), keyspace.cqlName()));
                }
                udt = ImmutableUserDefinedType.builder().keyspace(keyspace.name()).name(udtName).build();
            }
            return udt;
        }

        private static Type parseBaseType(String str) {
            for (Type t : Type.values()) {
                if (t == UDT || !t.name().equalsIgnoreCase(str)) continue;
                return t;
            }
            return null;
        }

        @Override
        public TypeCodec codec() {
            return this.getCodecs().codec();
        }

        private ColumnUtils.Codecs getCodecs() {
            return ColumnUtils.CODECS.get(this);
        }

        @Override
        public String toString(Object value) {
            if (value == null) {
                return "null";
            }
            String format = Column.toCQLString(this, value);
            if (this.requiresQuotes) {
                return format.substring(1, format.length() - 1);
            }
            return format;
        }

        @Override
        public Object fromString(String value) {
            if (this.requiresQuotes) {
                return this.codec().parse("'" + value + "'");
            }
            return this.codec().parse(value);
        }

        public ParameterizedType.Builder builder() {
            throw new UnsupportedOperationException();
        }

        public String description() {
            return this.description;
        }

        public String usage() {
            return this.usage == null ? this.name() : this.usage;
        }

        @Override
        public ColumnType fieldType(String name) {
            throw new UnsupportedOperationException(String.format("'%s' is a raw type and does not have nested columns", this.name()));
        }

        static {
            int maxId = -1;
            for (Type t : Type.values()) {
                maxId = Math.max(maxId, t.id());
            }
            ids = new Type[maxId + 1];
            for (Type t : Type.values()) {
                if (t.id <= 0) continue;
                Type.ids[t.id] = t;
            }
        }
    }

    public static interface ColumnType
    extends Serializable {
        public static final AttachmentPoint CUSTOM_ATTACHMENT_POINT = new AttachmentPoint(){

            @Override
            public ProtocolVersion getProtocolVersion() {
                return ProtocolVersion.DEFAULT;
            }

            @Override
            public CodecRegistry getCodecRegistry() {
                return CODEC_REGISTRY;
            }
        };

        public int id();

        public Type rawType();

        public Class<?> javaType();

        default public String marshalTypeName() {
            throw new UnsupportedOperationException("marshalTypeName() not supported by " + this.name());
        }

        default public boolean isParameterized() {
            return false;
        }

        @Value.Default
        default public boolean isFrozen() {
            return false;
        }

        default public ColumnType frozen(boolean frozen) {
            return this;
        }

        default public ColumnType frozen() {
            return this.frozen(true);
        }

        default public ColumnType of(ColumnType ... types) {
            throw new UnsupportedOperationException("ColumnType.of() not supported by " + this.rawType());
        }

        default public Object validate(Object value, String location) throws ValidationException {
            if (value == null || this.javaType().isInstance(value)) {
                return value;
            }
            try {
                NumberCoercion.Result result = NumberCoercion.coerceToColumnType(this.javaType(), value);
                if (!result.columnTypeAcceptsValue()) {
                    throw new ValidationException(value.getClass(), this, location);
                }
                return result.getValidatedValue();
            }
            catch (ArithmeticException e) {
                throw new ValidationException(value.getClass(), this, e.getMessage(), location);
            }
        }

        @Value.Lazy
        public String cqlDefinition();

        public String name();

        @Value.Lazy
        public TypeCodec codec();

        default public String toCQLString(Object value) {
            return Column.toCQLString(this, value);
        }

        default public String toString(Object value) {
            return this.toCQLString(value);
        }

        default public Object fromString(String value) {
            return this.codec().parse(value);
        }

        default public <T> T create(Object ... parameters) {
            throw new UnsupportedOperationException("ColumnType.create(...) not supported by " + this.rawType());
        }

        default public List<ColumnType> parameters() {
            throw new UnsupportedOperationException("ColumnType.parameters() not supported by " + this.rawType());
        }

        @Value.Lazy
        default public ColumnType dereference(Keyspace keyspace) {
            return this;
        }

        default public boolean isCollection() {
            return false;
        }

        default public boolean isUserDefined() {
            return false;
        }

        default public boolean isTuple() {
            return false;
        }

        default public boolean isList() {
            return false;
        }

        default public boolean isMap() {
            return false;
        }

        default public boolean isSet() {
            return false;
        }

        default public boolean isComplexType() {
            return this.isParameterized() || this.isUserDefined();
        }

        public ColumnType fieldType(String var1);
    }

    public static enum Order {
        ASC,
        DESC;


        Order reversed() {
            if (this == ASC) {
                return DESC;
            }
            return ASC;
        }
    }
}

