/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.schema.ColumnUtils;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ColumnUtils.Codecs", generator="Immutables")
@SuppressFBWarnings
@Immutable
final class ImmutableCodecs
extends ColumnUtils.Codecs {
    private final TypeCodec codec;
    private final transient int hashCode;

    private ImmutableCodecs(TypeCodec codec) {
        this.codec = codec;
        this.hashCode = this.computeHashCode();
    }

    @Override
    TypeCodec codec() {
        return this.codec;
    }

    public final ImmutableCodecs withCodec(TypeCodec value) {
        if (this.codec == value) {
            return this;
        }
        TypeCodec newValue = Objects.requireNonNull(value, "codec");
        return new ImmutableCodecs(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCodecs && this.equalTo((ImmutableCodecs)another);
    }

    private boolean equalTo(ImmutableCodecs another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.codec.equals(another.codec);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.codec.hashCode();
        return h;
    }

    public String toString() {
        return "Codecs{codec=" + this.codec + "}";
    }

    public static ImmutableCodecs copyOf(ColumnUtils.Codecs instance) {
        if (instance instanceof ImmutableCodecs) {
            return (ImmutableCodecs)instance;
        }
        return ImmutableCodecs.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ColumnUtils.Codecs", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CODEC = 1L;
        private long initBits = 1L;
        @Nullable
        private TypeCodec codec;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ColumnUtils.Codecs instance) {
            Objects.requireNonNull(instance, "instance");
            this.codec(instance.codec());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder codec(TypeCodec codec) {
            this.codec = Objects.requireNonNull(codec, "codec");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableCodecs build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCodecs(this.codec);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("codec");
            }
            return "Cannot build Codecs, some of required attributes are not set " + attributes;
        }
    }
}

