/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.schema.CollectionIndexingType;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CollectionIndexingType", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableCollectionIndexingType
extends CollectionIndexingType {
    private final boolean indexKeys;
    private final boolean indexValues;
    private final boolean indexEntries;
    private final boolean indexFull;
    private final int hashCode;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCollectionIndexingType(Builder builder) {
        if (builder.indexKeysIsSet()) {
            this.initShim.indexKeys(builder.indexKeys);
        }
        if (builder.indexValuesIsSet()) {
            this.initShim.indexValues(builder.indexValues);
        }
        if (builder.indexEntriesIsSet()) {
            this.initShim.indexEntries(builder.indexEntries);
        }
        if (builder.indexFullIsSet()) {
            this.initShim.indexFull(builder.indexFull);
        }
        this.indexKeys = this.initShim.indexKeys();
        this.indexValues = this.initShim.indexValues();
        this.indexEntries = this.initShim.indexEntries();
        this.indexFull = this.initShim.indexFull();
        this.hashCode = this.computeHashCode();
        this.initShim = null;
    }

    private ImmutableCollectionIndexingType(boolean indexKeys, boolean indexValues, boolean indexEntries, boolean indexFull) {
        this.indexKeys = indexKeys;
        this.indexValues = indexValues;
        this.indexEntries = indexEntries;
        this.indexFull = indexFull;
        this.hashCode = this.computeHashCode();
        this.initShim = null;
    }

    @Override
    public boolean indexKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.indexKeys() : this.indexKeys;
    }

    @Override
    public boolean indexValues() {
        InitShim shim = this.initShim;
        return shim != null ? shim.indexValues() : this.indexValues;
    }

    @Override
    public boolean indexEntries() {
        InitShim shim = this.initShim;
        return shim != null ? shim.indexEntries() : this.indexEntries;
    }

    @Override
    public boolean indexFull() {
        InitShim shim = this.initShim;
        return shim != null ? shim.indexFull() : this.indexFull;
    }

    public final ImmutableCollectionIndexingType withIndexKeys(boolean value) {
        if (this.indexKeys == value) {
            return this;
        }
        return new ImmutableCollectionIndexingType(value, this.indexValues, this.indexEntries, this.indexFull);
    }

    public final ImmutableCollectionIndexingType withIndexValues(boolean value) {
        if (this.indexValues == value) {
            return this;
        }
        return new ImmutableCollectionIndexingType(this.indexKeys, value, this.indexEntries, this.indexFull);
    }

    public final ImmutableCollectionIndexingType withIndexEntries(boolean value) {
        if (this.indexEntries == value) {
            return this;
        }
        return new ImmutableCollectionIndexingType(this.indexKeys, this.indexValues, value, this.indexFull);
    }

    public final ImmutableCollectionIndexingType withIndexFull(boolean value) {
        if (this.indexFull == value) {
            return this;
        }
        return new ImmutableCollectionIndexingType(this.indexKeys, this.indexValues, this.indexEntries, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCollectionIndexingType && this.equalTo((ImmutableCollectionIndexingType)another);
    }

    private boolean equalTo(ImmutableCollectionIndexingType another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.indexKeys == another.indexKeys && this.indexValues == another.indexValues && this.indexEntries == another.indexEntries && this.indexFull == another.indexFull;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.indexKeys);
        h += (h << 5) + Boolean.hashCode(this.indexValues);
        h += (h << 5) + Boolean.hashCode(this.indexEntries);
        h += (h << 5) + Boolean.hashCode(this.indexFull);
        return h;
    }

    public String toString() {
        return "CollectionIndexingType{indexKeys=" + this.indexKeys + ", indexValues=" + this.indexValues + ", indexEntries=" + this.indexEntries + ", indexFull=" + this.indexFull + "}";
    }

    public static ImmutableCollectionIndexingType copyOf(CollectionIndexingType instance) {
        if (instance instanceof ImmutableCollectionIndexingType) {
            return (ImmutableCollectionIndexingType)instance;
        }
        return ImmutableCollectionIndexingType.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return new ImmutableCollectionIndexingType(this.indexKeys, this.indexValues, this.indexEntries, this.indexFull);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CollectionIndexingType", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_INDEX_KEYS = 1L;
        private static final long OPT_BIT_INDEX_VALUES = 2L;
        private static final long OPT_BIT_INDEX_ENTRIES = 4L;
        private static final long OPT_BIT_INDEX_FULL = 8L;
        private long optBits;
        private boolean indexKeys;
        private boolean indexValues;
        private boolean indexEntries;
        private boolean indexFull;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CollectionIndexingType instance) {
            Objects.requireNonNull(instance, "instance");
            this.indexKeys(instance.indexKeys());
            this.indexValues(instance.indexValues());
            this.indexEntries(instance.indexEntries());
            this.indexFull(instance.indexFull());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder indexKeys(boolean indexKeys) {
            this.indexKeys = indexKeys;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder indexValues(boolean indexValues) {
            this.indexValues = indexValues;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder indexEntries(boolean indexEntries) {
            this.indexEntries = indexEntries;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder indexFull(boolean indexFull) {
            this.indexFull = indexFull;
            this.optBits |= 8L;
            return this;
        }

        public ImmutableCollectionIndexingType build() {
            return new ImmutableCollectionIndexingType(this);
        }

        private boolean indexKeysIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean indexValuesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean indexEntriesIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean indexFullIsSet() {
            return (this.optBits & 8L) != 0L;
        }
    }

    @Generated(from="CollectionIndexingType", generator="Immutables")
    private final class InitShim {
        private byte indexKeysBuildStage = 0;
        private boolean indexKeys;
        private byte indexValuesBuildStage = 0;
        private boolean indexValues;
        private byte indexEntriesBuildStage = 0;
        private boolean indexEntries;
        private byte indexFullBuildStage = 0;
        private boolean indexFull;

        private InitShim() {
        }

        boolean indexKeys() {
            if (this.indexKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.indexKeysBuildStage == 0) {
                this.indexKeysBuildStage = (byte)-1;
                this.indexKeys = ImmutableCollectionIndexingType.super.indexKeys();
                this.indexKeysBuildStage = 1;
            }
            return this.indexKeys;
        }

        void indexKeys(boolean indexKeys) {
            this.indexKeys = indexKeys;
            this.indexKeysBuildStage = 1;
        }

        boolean indexValues() {
            if (this.indexValuesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.indexValuesBuildStage == 0) {
                this.indexValuesBuildStage = (byte)-1;
                this.indexValues = ImmutableCollectionIndexingType.super.indexValues();
                this.indexValuesBuildStage = 1;
            }
            return this.indexValues;
        }

        void indexValues(boolean indexValues) {
            this.indexValues = indexValues;
            this.indexValuesBuildStage = 1;
        }

        boolean indexEntries() {
            if (this.indexEntriesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.indexEntriesBuildStage == 0) {
                this.indexEntriesBuildStage = (byte)-1;
                this.indexEntries = ImmutableCollectionIndexingType.super.indexEntries();
                this.indexEntriesBuildStage = 1;
            }
            return this.indexEntries;
        }

        void indexEntries(boolean indexEntries) {
            this.indexEntries = indexEntries;
            this.indexEntriesBuildStage = 1;
        }

        boolean indexFull() {
            if (this.indexFullBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.indexFullBuildStage == 0) {
                this.indexFullBuildStage = (byte)-1;
                this.indexFull = ImmutableCollectionIndexingType.super.indexFull();
                this.indexFullBuildStage = 1;
            }
            return this.indexFull;
        }

        void indexFull(boolean indexFull) {
            this.indexFull = indexFull;
            this.indexFullBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.indexKeysBuildStage == -1) {
                attributes.add("indexKeys");
            }
            if (this.indexValuesBuildStage == -1) {
                attributes.add("indexValues");
            }
            if (this.indexEntriesBuildStage == -1) {
                attributes.add("indexEntries");
            }
            if (this.indexFullBuildStage == -1) {
                attributes.add("indexFull");
            }
            return "Cannot build CollectionIndexingType, attribute initializers form cycle " + attributes;
        }
    }
}

